package io.vertx.mutiny.ext.consul;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.consul.WatchResult.class)
public class WatchResult<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<WatchResult> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WatchResult((io.vertx.ext.consul.WatchResult) obj),
    WatchResult::getDelegate
  );

  private final io.vertx.ext.consul.WatchResult<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public WatchResult(io.vertx.ext.consul.WatchResult delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public WatchResult(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.consul.WatchResult)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public WatchResult(io.vertx.ext.consul.WatchResult delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WatchResult() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.ext.consul.WatchResult getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WatchResult that = (WatchResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the previous result.
   */
  public T prevResult() { 
    T ret = (T)__typeArg_0.wrap(delegate.prevResult());
    return ret;
  }

  /**
   * @return the next result or null if the operation failed.
   */
  public T nextResult() { 
    T ret = (T)__typeArg_0.wrap(delegate.nextResult());
    return ret;
  }

  /**
   * @return the cause or null if the operation succeeded.
   */
  public java.lang.Throwable cause() { 
    java.lang.Throwable ret = delegate.cause();
    return ret;
  }

  /**
   * @return true if it succeded or false otherwise
   */
  public boolean succeeded() { 
    boolean ret = delegate.succeeded();
    return ret;
  }

  /**
   * @return true if it failed or false otherwise
   */
  public boolean failed() { 
    boolean ret = delegate.failed();
    return ret;
  }

  public static <T>WatchResult<T> newInstance(io.vertx.ext.consul.WatchResult arg) {
    return arg != null ? new WatchResult<T>(arg) : null;
  }


  public static <T>WatchResult<T> newInstance(io.vertx.ext.consul.WatchResult arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new WatchResult<T>(arg, __typeArg_T) : null;
  }

}
