/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.consul;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.policy.AclPolicy;
import io.vertx.ext.consul.token.CloneAclTokenOptions;
import java.util.List;

@MutinyGen(value=io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient
implements MutinyDelegate {
    public static final TypeArg<ConsulClient> __TYPE_ARG = new TypeArg(obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient)obj), ConsulClient::getDelegate);
    private final io.vertx.ext.consul.ConsulClient delegate;

    public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
        this.delegate = delegate;
    }

    public ConsulClient(Object delegate) {
        this.delegate = (io.vertx.ext.consul.ConsulClient)delegate;
    }

    ConsulClient() {
        this.delegate = null;
    }

    public io.vertx.ext.consul.ConsulClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsulClient that = (ConsulClient)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static ConsulClient create(io.vertx.mutiny.core.Vertx vertx) {
        ConsulClient ret = ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static ConsulClient create(io.vertx.mutiny.core.Vertx vertx, ConsulClientOptions options) {
        ConsulClient ret = ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create((Vertx)vertx.getDelegate(), (ConsulClientOptions)options));
        return ret;
    }

    @CheckReturnValue
    public Uni<JsonObject> agentInfo() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.agentInfo(resultHandler));
    }

    public JsonObject agentInfoAndAwait() {
        return (JsonObject)this.agentInfo().await().indefinitely();
    }

    @Fluent
    public ConsulClient agentInfoAndForget() {
        this.agentInfo().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CoordinateList> coordinateNodes() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.coordinateNodes(resultHandler));
    }

    public CoordinateList coordinateNodesAndAwait() {
        return (CoordinateList)this.coordinateNodes().await().indefinitely();
    }

    @Fluent
    public ConsulClient coordinateNodesAndForget() {
        this.coordinateNodes().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CoordinateList> coordinateNodesWithOptions(BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.coordinateNodesWithOptions(options, resultHandler));
    }

    public CoordinateList coordinateNodesWithOptionsAndAwait(BlockingQueryOptions options) {
        return (CoordinateList)this.coordinateNodesWithOptions(options).await().indefinitely();
    }

    @Fluent
    public ConsulClient coordinateNodesWithOptionsAndForget(BlockingQueryOptions options) {
        this.coordinateNodesWithOptions(options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<DcCoordinates>> coordinateDatacenters() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.coordinateDatacenters(resultHandler));
    }

    public List<DcCoordinates> coordinateDatacentersAndAwait() {
        return (List)this.coordinateDatacenters().await().indefinitely();
    }

    @Fluent
    public ConsulClient coordinateDatacentersAndForget() {
        this.coordinateDatacenters().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> getKeys(String keyPrefix) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getKeys(keyPrefix, resultHandler));
    }

    public List<String> getKeysAndAwait(String keyPrefix) {
        return (List)this.getKeys(keyPrefix).await().indefinitely();
    }

    @Fluent
    public ConsulClient getKeysAndForget(String keyPrefix) {
        this.getKeys(keyPrefix).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> getKeysWithOptions(String keyPrefix, BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getKeysWithOptions(keyPrefix, options, resultHandler));
    }

    public List<String> getKeysWithOptionsAndAwait(String keyPrefix, BlockingQueryOptions options) {
        return (List)this.getKeysWithOptions(keyPrefix, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient getKeysWithOptionsAndForget(String keyPrefix, BlockingQueryOptions options) {
        this.getKeysWithOptions(keyPrefix, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<KeyValue> getValue(String key) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getValue(key, resultHandler));
    }

    public KeyValue getValueAndAwait(String key) {
        return (KeyValue)this.getValue(key).await().indefinitely();
    }

    @Fluent
    public ConsulClient getValueAndForget(String key) {
        this.getValue(key).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<KeyValue> getValueWithOptions(String key, BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getValueWithOptions(key, options, resultHandler));
    }

    public KeyValue getValueWithOptionsAndAwait(String key, BlockingQueryOptions options) {
        return (KeyValue)this.getValueWithOptions(key, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient getValueWithOptionsAndForget(String key, BlockingQueryOptions options) {
        this.getValueWithOptions(key, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deleteValue(String key) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deleteValue(key, resultHandler));
    }

    public Void deleteValueAndAwait(String key) {
        return (Void)this.deleteValue(key).await().indefinitely();
    }

    @Fluent
    public ConsulClient deleteValueAndForget(String key) {
        this.deleteValue(key).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<KeyValueList> getValues(String keyPrefix) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getValues(keyPrefix, resultHandler));
    }

    public KeyValueList getValuesAndAwait(String keyPrefix) {
        return (KeyValueList)this.getValues(keyPrefix).await().indefinitely();
    }

    @Fluent
    public ConsulClient getValuesAndForget(String keyPrefix) {
        this.getValues(keyPrefix).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<KeyValueList> getValuesWithOptions(String keyPrefix, BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getValuesWithOptions(keyPrefix, options, resultHandler));
    }

    public KeyValueList getValuesWithOptionsAndAwait(String keyPrefix, BlockingQueryOptions options) {
        return (KeyValueList)this.getValuesWithOptions(keyPrefix, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient getValuesWithOptionsAndForget(String keyPrefix, BlockingQueryOptions options) {
        this.getValuesWithOptions(keyPrefix, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deleteValues(String keyPrefix) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deleteValues(keyPrefix, resultHandler));
    }

    public Void deleteValuesAndAwait(String keyPrefix) {
        return (Void)this.deleteValues(keyPrefix).await().indefinitely();
    }

    @Fluent
    public ConsulClient deleteValuesAndForget(String keyPrefix) {
        this.deleteValues(keyPrefix).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Boolean> putValue(String key, String value) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.putValue(key, value, resultHandler));
    }

    public Boolean putValueAndAwait(String key, String value) {
        return (Boolean)this.putValue(key, value).await().indefinitely();
    }

    @Fluent
    public ConsulClient putValueAndForget(String key, String value) {
        this.putValue(key, value).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Boolean> putValueWithOptions(String key, String value, KeyValueOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.putValueWithOptions(key, value, options, resultHandler));
    }

    public Boolean putValueWithOptionsAndAwait(String key, String value, KeyValueOptions options) {
        return (Boolean)this.putValueWithOptions(key, value, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient putValueWithOptionsAndForget(String key, String value, KeyValueOptions options) {
        this.putValueWithOptions(key, value, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<TxnResponse> transaction(TxnRequest request) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.transaction(request, resultHandler));
    }

    public TxnResponse transactionAndAwait(TxnRequest request) {
        return (TxnResponse)this.transaction(request).await().indefinitely();
    }

    @Fluent
    public ConsulClient transactionAndForget(TxnRequest request) {
        this.transaction(request).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> createAclPolicy(AclPolicy policy) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createAclPolicy(policy, resultHandler));
    }

    public String createAclPolicyAndAwait(AclPolicy policy) {
        return (String)this.createAclPolicy(policy).await().indefinitely();
    }

    @Fluent
    public ConsulClient createAclPolicyAndForget(AclPolicy policy) {
        this.createAclPolicy(policy).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AclPolicy> readPolicy(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.readPolicy(id, resultHandler));
    }

    public AclPolicy readPolicyAndAwait(String id) {
        return (AclPolicy)this.readPolicy(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient readPolicyAndForget(String id) {
        this.readPolicy(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AclPolicy> readPolicyByName(String name) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.readPolicyByName(name, resultHandler));
    }

    public AclPolicy readPolicyByNameAndAwait(String name) {
        return (AclPolicy)this.readPolicyByName(name).await().indefinitely();
    }

    @Fluent
    public ConsulClient readPolicyByNameAndForget(String name) {
        this.readPolicyByName(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AclPolicy> updatePolicy(String id, AclPolicy policy) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updatePolicy(id, policy, resultHandler));
    }

    public AclPolicy updatePolicyAndAwait(String id, AclPolicy policy) {
        return (AclPolicy)this.updatePolicy(id, policy).await().indefinitely();
    }

    @Fluent
    public ConsulClient updatePolicyAndForget(String id, AclPolicy policy) {
        this.updatePolicy(id, policy).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Boolean> deletePolicy(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deletePolicy(id, resultHandler));
    }

    public Boolean deletePolicyAndAwait(String id) {
        return (Boolean)this.deletePolicy(id).await().indefinitely();
    }

    public void deletePolicyAndForget(String id) {
        this.deletePolicy(id).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<List<AclPolicy>> getAclPolicies() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getAclPolicies(resultHandler));
    }

    public List<AclPolicy> getAclPoliciesAndAwait() {
        return (List)this.getAclPolicies().await().indefinitely();
    }

    public void getAclPoliciesAndForget() {
        this.getAclPolicies().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<io.vertx.ext.consul.token.AclToken> createAclToken(io.vertx.ext.consul.token.AclToken token) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createAclToken(token, resultHandler));
    }

    public io.vertx.ext.consul.token.AclToken createAclTokenAndAwait(io.vertx.ext.consul.token.AclToken token) {
        return (io.vertx.ext.consul.token.AclToken)this.createAclToken(token).await().indefinitely();
    }

    @Fluent
    public ConsulClient createAclTokenAndForget(io.vertx.ext.consul.token.AclToken token) {
        this.createAclToken(token).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<io.vertx.ext.consul.token.AclToken> updateAclToken(String accessorId, io.vertx.ext.consul.token.AclToken token) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateAclToken(accessorId, token, resultHandler));
    }

    public io.vertx.ext.consul.token.AclToken updateAclTokenAndAwait(String accessorId, io.vertx.ext.consul.token.AclToken token) {
        return (io.vertx.ext.consul.token.AclToken)this.updateAclToken(accessorId, token).await().indefinitely();
    }

    @Fluent
    public ConsulClient updateAclTokenAndForget(String accessorId, io.vertx.ext.consul.token.AclToken token) {
        this.updateAclToken(accessorId, token).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<io.vertx.ext.consul.token.AclToken> cloneAclToken(String accessorId, CloneAclTokenOptions cloneAclToken) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.cloneAclToken(accessorId, cloneAclToken, resultHandler));
    }

    public io.vertx.ext.consul.token.AclToken cloneAclTokenAndAwait(String accessorId, CloneAclTokenOptions cloneAclToken) {
        return (io.vertx.ext.consul.token.AclToken)this.cloneAclToken(accessorId, cloneAclToken).await().indefinitely();
    }

    @Fluent
    public ConsulClient cloneAclTokenAndForget(String accessorId, CloneAclTokenOptions cloneAclToken) {
        this.cloneAclToken(accessorId, cloneAclToken).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<io.vertx.ext.consul.token.AclToken>> getAclTokens() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getAclTokens(resultHandler));
    }

    public List<io.vertx.ext.consul.token.AclToken> getAclTokensAndAwait() {
        return (List)this.getAclTokens().await().indefinitely();
    }

    @Fluent
    public ConsulClient getAclTokensAndForget() {
        this.getAclTokens().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<io.vertx.ext.consul.token.AclToken> readAclToken(String accessorId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.readAclToken(accessorId, resultHandler));
    }

    public io.vertx.ext.consul.token.AclToken readAclTokenAndAwait(String accessorId) {
        return (io.vertx.ext.consul.token.AclToken)this.readAclToken(accessorId).await().indefinitely();
    }

    @Fluent
    public ConsulClient readAclTokenAndForget(String accessorId) {
        this.readAclToken(accessorId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Boolean> deleteAclToken(String accessorId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deleteAclToken(accessorId, resultHandler));
    }

    public Boolean deleteAclTokenAndAwait(String accessorId) {
        return (Boolean)this.deleteAclToken(accessorId).await().indefinitely();
    }

    @Fluent
    public ConsulClient deleteAclTokenAndForget(String accessorId) {
        this.deleteAclToken(accessorId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<String> createAclToken(AclToken token) {
        return AsyncResultUni.toUni(idHandler -> this.delegate.createAclToken(token, idHandler));
    }

    @Deprecated
    public String createAclTokenAndAwait(AclToken token) {
        return (String)this.createAclToken(token).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public ConsulClient createAclTokenAndForget(AclToken token) {
        this.createAclToken(token).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<String> updateAclToken(AclToken token) {
        return AsyncResultUni.toUni(idHandler -> this.delegate.updateAclToken(token, idHandler));
    }

    @Deprecated
    public String updateAclTokenAndAwait(AclToken token) {
        return (String)this.updateAclToken(token).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public ConsulClient updateAclTokenAndForget(AclToken token) {
        this.updateAclToken(token).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<String> cloneAclToken(String id) {
        return AsyncResultUni.toUni(idHandler -> this.delegate.cloneAclToken(id, idHandler));
    }

    @Deprecated
    public String cloneAclTokenAndAwait(String id) {
        return (String)this.cloneAclToken(id).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public ConsulClient cloneAclTokenAndForget(String id) {
        this.cloneAclToken(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<List<AclToken>> listAclTokens() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listAclTokens(resultHandler));
    }

    @Deprecated
    public List<AclToken> listAclTokensAndAwait() {
        return (List)this.listAclTokens().await().indefinitely();
    }

    @Deprecated
    @Fluent
    public ConsulClient listAclTokensAndForget() {
        this.listAclTokens().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<AclToken> infoAclToken(String id) {
        return AsyncResultUni.toUni(tokenHandler -> this.delegate.infoAclToken(id, tokenHandler));
    }

    @Deprecated
    public AclToken infoAclTokenAndAwait(String id) {
        return (AclToken)this.infoAclToken(id).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public ConsulClient infoAclTokenAndForget(String id) {
        this.infoAclToken(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<Void> destroyAclToken(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.destroyAclToken(id, resultHandler));
    }

    @Deprecated
    public Void destroyAclTokenAndAwait(String id) {
        return (Void)this.destroyAclToken(id).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public ConsulClient destroyAclTokenAndForget(String id) {
        this.destroyAclToken(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Event> fireEvent(String name) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.fireEvent(name, resultHandler));
    }

    public Event fireEventAndAwait(String name) {
        return (Event)this.fireEvent(name).await().indefinitely();
    }

    @Fluent
    public ConsulClient fireEventAndForget(String name) {
        this.fireEvent(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Event> fireEventWithOptions(String name, EventOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.fireEventWithOptions(name, options, resultHandler));
    }

    public Event fireEventWithOptionsAndAwait(String name, EventOptions options) {
        return (Event)this.fireEventWithOptions(name, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient fireEventWithOptionsAndForget(String name, EventOptions options) {
        this.fireEventWithOptions(name, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<EventList> listEvents() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listEvents(resultHandler));
    }

    public EventList listEventsAndAwait() {
        return (EventList)this.listEvents().await().indefinitely();
    }

    @Fluent
    public ConsulClient listEventsAndForget() {
        this.listEvents().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<EventList> listEventsWithOptions(EventListOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listEventsWithOptions(options, resultHandler));
    }

    public EventList listEventsWithOptionsAndAwait(EventListOptions options) {
        return (EventList)this.listEventsWithOptions(options).await().indefinitely();
    }

    @Fluent
    public ConsulClient listEventsWithOptionsAndForget(EventListOptions options) {
        this.listEventsWithOptions(options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> registerService(ServiceOptions serviceOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.registerService(serviceOptions, resultHandler));
    }

    public Void registerServiceAndAwait(ServiceOptions serviceOptions) {
        return (Void)this.registerService(serviceOptions).await().indefinitely();
    }

    @Fluent
    public ConsulClient registerServiceAndForget(ServiceOptions serviceOptions) {
        this.registerService(serviceOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> maintenanceService(MaintenanceOptions maintenanceOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.maintenanceService(maintenanceOptions, resultHandler));
    }

    public Void maintenanceServiceAndAwait(MaintenanceOptions maintenanceOptions) {
        return (Void)this.maintenanceService(maintenanceOptions).await().indefinitely();
    }

    @Fluent
    public ConsulClient maintenanceServiceAndForget(MaintenanceOptions maintenanceOptions) {
        this.maintenanceService(maintenanceOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deregisterService(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deregisterService(id, resultHandler));
    }

    public Void deregisterServiceAndAwait(String id) {
        return (Void)this.deregisterService(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient deregisterServiceAndForget(String id) {
        this.deregisterService(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceList> catalogServiceNodes(String service) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogServiceNodes(service, resultHandler));
    }

    public ServiceList catalogServiceNodesAndAwait(String service) {
        return (ServiceList)this.catalogServiceNodes(service).await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogServiceNodesAndForget(String service) {
        this.catalogServiceNodes(service).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceList> catalogServiceNodesWithOptions(String service, ServiceQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogServiceNodesWithOptions(service, options, resultHandler));
    }

    public ServiceList catalogServiceNodesWithOptionsAndAwait(String service, ServiceQueryOptions options) {
        return (ServiceList)this.catalogServiceNodesWithOptions(service, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogServiceNodesWithOptionsAndForget(String service, ServiceQueryOptions options) {
        this.catalogServiceNodesWithOptions(service, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> catalogDatacenters() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogDatacenters(resultHandler));
    }

    public List<String> catalogDatacentersAndAwait() {
        return (List)this.catalogDatacenters().await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogDatacentersAndForget() {
        this.catalogDatacenters().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NodeList> catalogNodes() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogNodes(resultHandler));
    }

    public NodeList catalogNodesAndAwait() {
        return (NodeList)this.catalogNodes().await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogNodesAndForget() {
        this.catalogNodes().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<NodeList> catalogNodesWithOptions(NodeQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogNodesWithOptions(options, resultHandler));
    }

    public NodeList catalogNodesWithOptionsAndAwait(NodeQueryOptions options) {
        return (NodeList)this.catalogNodesWithOptions(options).await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogNodesWithOptionsAndForget(NodeQueryOptions options) {
        this.catalogNodesWithOptions(options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CheckList> healthChecks(String service) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthChecks(service, resultHandler));
    }

    public CheckList healthChecksAndAwait(String service) {
        return (CheckList)this.healthChecks(service).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthChecksAndForget(String service) {
        this.healthChecks(service).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CheckList> healthChecksWithOptions(String service, CheckQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthChecksWithOptions(service, options, resultHandler));
    }

    public CheckList healthChecksWithOptionsAndAwait(String service, CheckQueryOptions options) {
        return (CheckList)this.healthChecksWithOptions(service, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthChecksWithOptionsAndForget(String service, CheckQueryOptions options) {
        this.healthChecksWithOptions(service, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CheckList> healthState(HealthState healthState) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthState(healthState, resultHandler));
    }

    public CheckList healthStateAndAwait(HealthState healthState) {
        return (CheckList)this.healthState(healthState).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthStateAndForget(HealthState healthState) {
        this.healthState(healthState).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CheckList> healthStateWithOptions(HealthState healthState, CheckQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthStateWithOptions(healthState, options, resultHandler));
    }

    public CheckList healthStateWithOptionsAndAwait(HealthState healthState, CheckQueryOptions options) {
        return (CheckList)this.healthStateWithOptions(healthState, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthStateWithOptionsAndForget(HealthState healthState, CheckQueryOptions options) {
        this.healthStateWithOptions(healthState, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceEntryList> healthServiceNodes(String service, boolean passing) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthServiceNodes(service, passing, resultHandler));
    }

    public ServiceEntryList healthServiceNodesAndAwait(String service, boolean passing) {
        return (ServiceEntryList)this.healthServiceNodes(service, passing).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthServiceNodesAndForget(String service, boolean passing) {
        this.healthServiceNodes(service, passing).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceEntryList> healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler));
    }

    public ServiceEntryList healthServiceNodesWithOptionsAndAwait(String service, boolean passing, ServiceQueryOptions options) {
        return (ServiceEntryList)this.healthServiceNodesWithOptions(service, passing, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthServiceNodesWithOptionsAndForget(String service, boolean passing, ServiceQueryOptions options) {
        this.healthServiceNodesWithOptions(service, passing, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CheckList> healthNodesWithOptions(String node, CheckQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.healthNodesWithOptions(node, options, resultHandler));
    }

    public CheckList healthNodesWithOptionsAndAwait(String node, CheckQueryOptions options) {
        return (CheckList)this.healthNodesWithOptions(node, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient healthNodesWithOptionsAndForget(String node, CheckQueryOptions options) {
        this.healthNodesWithOptions(node, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceList> catalogServices() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogServices(resultHandler));
    }

    public ServiceList catalogServicesAndAwait() {
        return (ServiceList)this.catalogServices().await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogServicesAndForget() {
        this.catalogServices().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceList> catalogServicesWithOptions(BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogServicesWithOptions(options, resultHandler));
    }

    public ServiceList catalogServicesWithOptionsAndAwait(BlockingQueryOptions options) {
        return (ServiceList)this.catalogServicesWithOptions(options).await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogServicesWithOptionsAndForget(BlockingQueryOptions options) {
        this.catalogServicesWithOptions(options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceList> catalogNodeServices(String node) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogNodeServices(node, resultHandler));
    }

    public ServiceList catalogNodeServicesAndAwait(String node) {
        return (ServiceList)this.catalogNodeServices(node).await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogNodeServicesAndForget(String node) {
        this.catalogNodeServices(node).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<ServiceList> catalogNodeServicesWithOptions(String node, BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.catalogNodeServicesWithOptions(node, options, resultHandler));
    }

    public ServiceList catalogNodeServicesWithOptionsAndAwait(String node, BlockingQueryOptions options) {
        return (ServiceList)this.catalogNodeServicesWithOptions(node, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient catalogNodeServicesWithOptionsAndForget(String node, BlockingQueryOptions options) {
        this.catalogNodeServicesWithOptions(node, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<Service>> localServices() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.localServices(resultHandler));
    }

    public List<Service> localServicesAndAwait() {
        return (List)this.localServices().await().indefinitely();
    }

    @Fluent
    public ConsulClient localServicesAndForget() {
        this.localServices().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<Check>> localChecks() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.localChecks(resultHandler));
    }

    public List<Check> localChecksAndAwait() {
        return (List)this.localChecks().await().indefinitely();
    }

    @Fluent
    public ConsulClient localChecksAndForget() {
        this.localChecks().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> registerCheck(CheckOptions checkOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.registerCheck(checkOptions, resultHandler));
    }

    public Void registerCheckAndAwait(CheckOptions checkOptions) {
        return (Void)this.registerCheck(checkOptions).await().indefinitely();
    }

    @Fluent
    public ConsulClient registerCheckAndForget(CheckOptions checkOptions) {
        this.registerCheck(checkOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deregisterCheck(String checkId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deregisterCheck(checkId, resultHandler));
    }

    public Void deregisterCheckAndAwait(String checkId) {
        return (Void)this.deregisterCheck(checkId).await().indefinitely();
    }

    @Fluent
    public ConsulClient deregisterCheckAndForget(String checkId) {
        this.deregisterCheck(checkId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> passCheck(String checkId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.passCheck(checkId, resultHandler));
    }

    public Void passCheckAndAwait(String checkId) {
        return (Void)this.passCheck(checkId).await().indefinitely();
    }

    @Fluent
    public ConsulClient passCheckAndForget(String checkId) {
        this.passCheck(checkId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> passCheckWithNote(String checkId, String note) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.passCheckWithNote(checkId, note, resultHandler));
    }

    public Void passCheckWithNoteAndAwait(String checkId, String note) {
        return (Void)this.passCheckWithNote(checkId, note).await().indefinitely();
    }

    @Fluent
    public ConsulClient passCheckWithNoteAndForget(String checkId, String note) {
        this.passCheckWithNote(checkId, note).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> warnCheck(String checkId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.warnCheck(checkId, resultHandler));
    }

    public Void warnCheckAndAwait(String checkId) {
        return (Void)this.warnCheck(checkId).await().indefinitely();
    }

    @Fluent
    public ConsulClient warnCheckAndForget(String checkId) {
        this.warnCheck(checkId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> warnCheckWithNote(String checkId, String note) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.warnCheckWithNote(checkId, note, resultHandler));
    }

    public Void warnCheckWithNoteAndAwait(String checkId, String note) {
        return (Void)this.warnCheckWithNote(checkId, note).await().indefinitely();
    }

    @Fluent
    public ConsulClient warnCheckWithNoteAndForget(String checkId, String note) {
        this.warnCheckWithNote(checkId, note).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> failCheck(String checkId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.failCheck(checkId, resultHandler));
    }

    public Void failCheckAndAwait(String checkId) {
        return (Void)this.failCheck(checkId).await().indefinitely();
    }

    @Fluent
    public ConsulClient failCheckAndForget(String checkId) {
        this.failCheck(checkId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> failCheckWithNote(String checkId, String note) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.failCheckWithNote(checkId, note, resultHandler));
    }

    public Void failCheckWithNoteAndAwait(String checkId, String note) {
        return (Void)this.failCheckWithNote(checkId, note).await().indefinitely();
    }

    @Fluent
    public ConsulClient failCheckWithNoteAndForget(String checkId, String note) {
        this.failCheckWithNote(checkId, note).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> updateCheck(String checkId, CheckStatus status) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateCheck(checkId, status, resultHandler));
    }

    public Void updateCheckAndAwait(String checkId, CheckStatus status) {
        return (Void)this.updateCheck(checkId, status).await().indefinitely();
    }

    @Fluent
    public ConsulClient updateCheckAndForget(String checkId, CheckStatus status) {
        this.updateCheck(checkId, status).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> updateCheckWithNote(String checkId, CheckStatus status, String note) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateCheckWithNote(checkId, status, note, resultHandler));
    }

    public Void updateCheckWithNoteAndAwait(String checkId, CheckStatus status, String note) {
        return (Void)this.updateCheckWithNote(checkId, status, note).await().indefinitely();
    }

    @Fluent
    public ConsulClient updateCheckWithNoteAndForget(String checkId, CheckStatus status, String note) {
        this.updateCheckWithNote(checkId, status, note).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> leaderStatus() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.leaderStatus(resultHandler));
    }

    public String leaderStatusAndAwait() {
        return (String)this.leaderStatus().await().indefinitely();
    }

    @Fluent
    public ConsulClient leaderStatusAndForget() {
        this.leaderStatus().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> peersStatus() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.peersStatus(resultHandler));
    }

    public List<String> peersStatusAndAwait() {
        return (List)this.peersStatus().await().indefinitely();
    }

    @Fluent
    public ConsulClient peersStatusAndForget() {
        this.peersStatus().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> createSession() {
        return AsyncResultUni.toUni(idHandler -> this.delegate.createSession(idHandler));
    }

    public String createSessionAndAwait() {
        return (String)this.createSession().await().indefinitely();
    }

    @Fluent
    public ConsulClient createSessionAndForget() {
        this.createSession().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> createSessionWithOptions(SessionOptions options) {
        return AsyncResultUni.toUni(idHandler -> this.delegate.createSessionWithOptions(options, idHandler));
    }

    public String createSessionWithOptionsAndAwait(SessionOptions options) {
        return (String)this.createSessionWithOptions(options).await().indefinitely();
    }

    @Fluent
    public ConsulClient createSessionWithOptionsAndForget(SessionOptions options) {
        this.createSessionWithOptions(options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Session> infoSession(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.infoSession(id, resultHandler));
    }

    public Session infoSessionAndAwait(String id) {
        return (Session)this.infoSession(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient infoSessionAndForget(String id) {
        this.infoSession(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Session> infoSessionWithOptions(String id, BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.infoSessionWithOptions(id, options, resultHandler));
    }

    public Session infoSessionWithOptionsAndAwait(String id, BlockingQueryOptions options) {
        return (Session)this.infoSessionWithOptions(id, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient infoSessionWithOptionsAndForget(String id, BlockingQueryOptions options) {
        this.infoSessionWithOptions(id, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Session> renewSession(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.renewSession(id, resultHandler));
    }

    public Session renewSessionAndAwait(String id) {
        return (Session)this.renewSession(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient renewSessionAndForget(String id) {
        this.renewSession(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<SessionList> listSessions() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listSessions(resultHandler));
    }

    public SessionList listSessionsAndAwait() {
        return (SessionList)this.listSessions().await().indefinitely();
    }

    @Fluent
    public ConsulClient listSessionsAndForget() {
        this.listSessions().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<SessionList> listSessionsWithOptions(BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listSessionsWithOptions(options, resultHandler));
    }

    public SessionList listSessionsWithOptionsAndAwait(BlockingQueryOptions options) {
        return (SessionList)this.listSessionsWithOptions(options).await().indefinitely();
    }

    @Fluent
    public ConsulClient listSessionsWithOptionsAndForget(BlockingQueryOptions options) {
        this.listSessionsWithOptions(options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<SessionList> listNodeSessions(String nodeId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listNodeSessions(nodeId, resultHandler));
    }

    public SessionList listNodeSessionsAndAwait(String nodeId) {
        return (SessionList)this.listNodeSessions(nodeId).await().indefinitely();
    }

    @Fluent
    public ConsulClient listNodeSessionsAndForget(String nodeId) {
        this.listNodeSessions(nodeId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<SessionList> listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler));
    }

    public SessionList listNodeSessionsWithOptionsAndAwait(String nodeId, BlockingQueryOptions options) {
        return (SessionList)this.listNodeSessionsWithOptions(nodeId, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient listNodeSessionsWithOptionsAndForget(String nodeId, BlockingQueryOptions options) {
        this.listNodeSessionsWithOptions(nodeId, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> destroySession(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.destroySession(id, resultHandler));
    }

    public Void destroySessionAndAwait(String id) {
        return (Void)this.destroySession(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient destroySessionAndForget(String id) {
        this.destroySession(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> createPreparedQuery(PreparedQueryDefinition definition) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createPreparedQuery(definition, resultHandler));
    }

    public String createPreparedQueryAndAwait(PreparedQueryDefinition definition) {
        return (String)this.createPreparedQuery(definition).await().indefinitely();
    }

    @Fluent
    public ConsulClient createPreparedQueryAndForget(PreparedQueryDefinition definition) {
        this.createPreparedQuery(definition).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<PreparedQueryDefinition> getPreparedQuery(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getPreparedQuery(id, resultHandler));
    }

    public PreparedQueryDefinition getPreparedQueryAndAwait(String id) {
        return (PreparedQueryDefinition)this.getPreparedQuery(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient getPreparedQueryAndForget(String id) {
        this.getPreparedQuery(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<PreparedQueryDefinition>> getAllPreparedQueries() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getAllPreparedQueries(resultHandler));
    }

    public List<PreparedQueryDefinition> getAllPreparedQueriesAndAwait() {
        return (List)this.getAllPreparedQueries().await().indefinitely();
    }

    @Fluent
    public ConsulClient getAllPreparedQueriesAndForget() {
        this.getAllPreparedQueries().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> updatePreparedQuery(PreparedQueryDefinition definition) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updatePreparedQuery(definition, resultHandler));
    }

    public Void updatePreparedQueryAndAwait(PreparedQueryDefinition definition) {
        return (Void)this.updatePreparedQuery(definition).await().indefinitely();
    }

    @Fluent
    public ConsulClient updatePreparedQueryAndForget(PreparedQueryDefinition definition) {
        this.updatePreparedQuery(definition).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deletePreparedQuery(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deletePreparedQuery(id, resultHandler));
    }

    public Void deletePreparedQueryAndAwait(String id) {
        return (Void)this.deletePreparedQuery(id).await().indefinitely();
    }

    @Fluent
    public ConsulClient deletePreparedQueryAndForget(String id) {
        this.deletePreparedQuery(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<PreparedQueryExecuteResponse> executePreparedQuery(String query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executePreparedQuery(query, resultHandler));
    }

    public PreparedQueryExecuteResponse executePreparedQueryAndAwait(String query) {
        return (PreparedQueryExecuteResponse)this.executePreparedQuery(query).await().indefinitely();
    }

    @Fluent
    public ConsulClient executePreparedQueryAndForget(String query) {
        this.executePreparedQuery(query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<PreparedQueryExecuteResponse> executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executePreparedQueryWithOptions(query, options, resultHandler));
    }

    public PreparedQueryExecuteResponse executePreparedQueryWithOptionsAndAwait(String query, PreparedQueryExecuteOptions options) {
        return (PreparedQueryExecuteResponse)this.executePreparedQueryWithOptions(query, options).await().indefinitely();
    }

    @Fluent
    public ConsulClient executePreparedQueryWithOptionsAndForget(String query, PreparedQueryExecuteOptions options) {
        this.executePreparedQueryWithOptions(query, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> registerCatalogService(Node nodeOptions, ServiceOptions serviceOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.registerCatalogService(nodeOptions, serviceOptions, resultHandler));
    }

    public Void registerCatalogServiceAndAwait(Node nodeOptions, ServiceOptions serviceOptions) {
        return (Void)this.registerCatalogService(nodeOptions, serviceOptions).await().indefinitely();
    }

    @Fluent
    public ConsulClient registerCatalogServiceAndForget(Node nodeOptions, ServiceOptions serviceOptions) {
        this.registerCatalogService(nodeOptions, serviceOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> deregisterCatalogService(String nodeId, String serviceId) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.deregisterCatalogService(nodeId, serviceId, resultHandler));
    }

    public Void deregisterCatalogServiceAndAwait(String nodeId, String serviceId) {
        return (Void)this.deregisterCatalogService(nodeId, serviceId).await().indefinitely();
    }

    @Fluent
    public ConsulClient deregisterCatalogServiceAndForget(String nodeId, String serviceId) {
        this.deregisterCatalogService(nodeId, serviceId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public static ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
        return arg != null ? new ConsulClient(arg) : null;
    }
}

