package io.vertx.mutiny.db2client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Supplier;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.sqlclient.PoolOptions;
import java.util.List;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.core.Handler;

/**
 * A pool of DB2 connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.db2client.DB2Pool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.db2client.DB2Pool.class)
@Deprecated
public class DB2Pool extends io.vertx.mutiny.sqlclient.Pool implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<DB2Pool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DB2Pool((io.vertx.db2client.DB2Pool) obj),
    DB2Pool::getDelegate
  );

  private final io.vertx.db2client.DB2Pool delegate;
  
  public DB2Pool(io.vertx.db2client.DB2Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public DB2Pool(Object delegate) {
    super((io.vertx.db2client.DB2Pool)delegate);
    this.delegate = (io.vertx.db2client.DB2Pool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DB2Pool() {
    super(null);
    this.delegate = null;
  }

  @Override
  public io.vertx.db2client.DB2Pool getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DB2Pool that = (DB2Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(String connectionUri) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(connectionUri, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * @param database the options for the connection
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(io.vertx.db2client.DB2ConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * @param databases the list of servers
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(List<io.vertx.db2client.DB2ConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(databases, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.db2client.DB2ConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), databases, options));
    return ret;
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(String connectionUri) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(connectionUri, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * @param database the options for the connection
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.db2client.DB2ConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * @param databases the list of servers
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(List<io.vertx.db2client.DB2ConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(databases, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.db2client.DB2ConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.db2client.DB2Pool.client(vertx.getDelegate(), databases, options));
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.db2client.DB2Pool __connectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.mutiny.db2client.DB2Pool connectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __connectHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  @Fluent
  public io.vertx.mutiny.db2client.DB2Pool connectionProvider(Function<io.vertx.mutiny.core.Context, io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new java.util.function.Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 provider.apply(io.vertx.mutiny.core.Context.newInstance((io.vertx.core.Context)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  /**
   * @param databases the databases supplier
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.db2client.DB2ConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.db2client.DB2Pool pool(io.vertx.mutiny.core.Vertx vertx, java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.db2client.DB2ConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.db2client.DB2Pool ret = io.vertx.mutiny.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), () -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), poolOptions));
    return ret;
  }

  public static  DB2Pool newInstance(io.vertx.db2client.DB2Pool arg) {
    return arg != null ? new DB2Pool(arg) : null;
  }

}
