package io.vertx.mutiny.httpproxy;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Handles the HTTP proxy body.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.Body original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.httpproxy.Body.class)
public class Body {

  public static final io.smallrye.mutiny.vertx.TypeArg<Body> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Body((io.vertx.httpproxy.Body) obj),
    Body::getDelegate
  );

  private final io.vertx.httpproxy.Body delegate;
  
  public Body(io.vertx.httpproxy.Body delegate) {
    this.delegate = delegate;
  }

  public Body(Object delegate) {
    this.delegate = (io.vertx.httpproxy.Body)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Body() {
    this.delegate = null;
  }

  public io.vertx.httpproxy.Body getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Body that = (Body) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param stream the <code>ReadStream</code> of the body
   * @param len the determined length of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.mutiny.httpproxy.Body body(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream, long len) { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(stream.getDelegate(), len));
    return ret;
  }

  /**
   * @param stream the <code>ReadStream</code> of the body
   * @param len the determined length of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.mutiny.httpproxy.Body body(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream, long len) { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume(), len));
    return ret;
  }

  /**
   * @param stream the  of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.mutiny.httpproxy.Body body(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(stream.getDelegate()));
    return ret;
  }

  /**
   * @param stream the  of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.mutiny.httpproxy.Body body(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * @param buffer the  of the body
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.mutiny.httpproxy.Body body(io.vertx.mutiny.core.buffer.Buffer buffer) { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)io.vertx.httpproxy.Body.body(buffer.getDelegate()));
    return ret;
  }

  /**
   * @return the body length or <code>-1</code> if that can't be determined
   */
  public long length() { 
    long ret = delegate.length();
    return ret;
  }

  /**
   * @return the body stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream() { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.stream(), TYPE_ARG_0);
    return ret;
  }

  public static  Body newInstance(io.vertx.httpproxy.Body arg) {
    return arg != null ? new Body(arg) : null;
  }

}
