package io.vertx.mutiny.httpproxy;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.httpproxy.ProxyOptions;
import io.vertx.core.Handler;
import java.util.function.Function;
import io.vertx.core.Future;

/**
 * Handles the HTTP reverse proxy logic between the <i><b>user agent</b></i> and the <i><b>origin</b></i>.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.HttpProxy original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.httpproxy.HttpProxy.class)
public class HttpProxy implements io.vertx.core.Handler<io.vertx.mutiny.core.http.HttpServerRequest>, java.util.function.Consumer<io.vertx.mutiny.core.http.HttpServerRequest> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpProxy> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpProxy((io.vertx.httpproxy.HttpProxy) obj),
    HttpProxy::getDelegate
  );

  private final io.vertx.httpproxy.HttpProxy delegate;
  
  public HttpProxy(io.vertx.httpproxy.HttpProxy delegate) {
    this.delegate = delegate;
  }

  public HttpProxy(Object delegate) {
    this.delegate = (io.vertx.httpproxy.HttpProxy)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpProxy() {
    this.delegate = null;
  }

  public io.vertx.httpproxy.HttpProxy getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpProxy that = (HttpProxy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param client the <code>HttpClient</code> that forwards <i><b>outbound</b></i> requests to the <i><b>origin</b></i>.
   * @return a reference to this, so the API can be used fluently.
   */
  public static io.vertx.mutiny.httpproxy.HttpProxy reverseProxy(io.vertx.mutiny.core.http.HttpClient client) { 
    io.vertx.mutiny.httpproxy.HttpProxy ret = io.vertx.mutiny.httpproxy.HttpProxy.newInstance((io.vertx.httpproxy.HttpProxy)io.vertx.httpproxy.HttpProxy.reverseProxy(client.getDelegate()));
    return ret;
  }

  /**
   * @param options 
   * @param client the <code>HttpClient</code> that forwards <i><b>outbound</b></i> requests to the <i><b>origin</b></i>.
   * @return a reference to this, so the API can be used fluently.
   */
  public static io.vertx.mutiny.httpproxy.HttpProxy reverseProxy(io.vertx.httpproxy.ProxyOptions options, io.vertx.mutiny.core.http.HttpClient client) { 
    io.vertx.mutiny.httpproxy.HttpProxy ret = io.vertx.mutiny.httpproxy.HttpProxy.newInstance((io.vertx.httpproxy.HttpProxy)io.vertx.httpproxy.HttpProxy.reverseProxy(options, client.getDelegate()));
    return ret;
  }

  /**
   * @param address the <code>SocketAddress</code> of the <i><b>origin</b></i>
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.HttpProxy origin(io.vertx.mutiny.core.net.SocketAddress address) { 
    delegate.origin(address.getDelegate());
    return this;
  }

  /**
   * @param port the port number of the <i><b>origin</b></i> server
   * @param host the host name of the <i><b>origin</b></i> server
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.HttpProxy origin(int port, String host) { 
    delegate.origin(port, host);
    return this;
  }

  /**
   * @param selector the selector
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.HttpProxy originSelector(Function<io.vertx.mutiny.core.http.HttpServerRequest, io.smallrye.mutiny.Uni<io.vertx.mutiny.core.net.SocketAddress>> selector) { 
    delegate.originSelector(new java.util.function.Function<io.vertx.core.http.HttpServerRequest,io.vertx.core.Future<io.vertx.core.net.SocketAddress>>() {
      public io.vertx.core.Future<io.vertx.core.net.SocketAddress> apply(io.vertx.core.http.HttpServerRequest arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 selector.apply(io.vertx.mutiny.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  /**
   * @param interceptor 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.HttpProxy addInterceptor(io.vertx.mutiny.httpproxy.ProxyInterceptor interceptor) { 
    delegate.addInterceptor(interceptor.getDelegate());
    return this;
  }

  /**
   * @param request the outbound <code>HttpServerRequest</code>
   */
  public void handle(io.vertx.mutiny.core.http.HttpServerRequest request) { 
    delegate.handle(request.getDelegate());
  }

  public void accept(io.vertx.mutiny.core.http.HttpServerRequest item) {
    handle(item);
  }
  public static  HttpProxy newInstance(io.vertx.httpproxy.HttpProxy arg) {
    return arg != null ? new HttpProxy(arg) : null;
  }

}
