package io.vertx.mutiny.httpproxy;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;

/**
 * A controller for proxy interception.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyContext original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.httpproxy.ProxyContext.class)
public class ProxyContext {

  public static final io.smallrye.mutiny.vertx.TypeArg<ProxyContext> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ProxyContext((io.vertx.httpproxy.ProxyContext) obj),
    ProxyContext::getDelegate
  );

  private final io.vertx.httpproxy.ProxyContext delegate;
  
  public ProxyContext(io.vertx.httpproxy.ProxyContext delegate) {
    this.delegate = delegate;
  }

  public ProxyContext(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyContext)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ProxyContext() {
    this.delegate = null;
  }

  public io.vertx.httpproxy.ProxyContext getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.httpproxy.ProxyResponse> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.httpproxy.ProxyResponse>(o1 -> io.vertx.mutiny.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxyContext that = (ProxyContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the proxy request
   */
  public io.vertx.mutiny.httpproxy.ProxyRequest request() { 
    io.vertx.mutiny.httpproxy.ProxyRequest ret = io.vertx.mutiny.httpproxy.ProxyRequest.newInstance((io.vertx.httpproxy.ProxyRequest)delegate.request());
    return ret;
  }

  /**
   * @return the proxy response, it might be <code>null</code> if the response has not been sent
   */
  public io.vertx.mutiny.httpproxy.ProxyResponse response() { 
    io.vertx.mutiny.httpproxy.ProxyResponse ret = io.vertx.mutiny.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)delegate.response());
    return ret;
  }

  /**
   *
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.httpproxy.ProxyResponse> sendRequest() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.sendRequest().map(x -> ProxyResponse.newInstance(x)));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyContext#sendRequest}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ProxyResponse instance produced by the operation.
   */
  public io.vertx.mutiny.httpproxy.ProxyResponse sendRequestAndAwait() { 
    return sendRequest().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyContext#sendRequest} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyContext#sendRequest}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyContext#sendRequest} but you don't need to compose it with other operations.
   */
  public void sendRequestAndForget() { 
    sendRequest().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   *
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendResponse() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.sendResponse());}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyContext#sendResponse}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void sendResponseAndAwait() { 
    return sendResponse().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyContext#sendResponse} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyContext#sendResponse}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyContext#sendResponse} but you don't need to compose it with other operations.
   */
  public void sendResponseAndForget() { 
    sendResponse().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @param name the payload name
   * @param value any payload value
   */
  public void set(String name, java.lang.Object value) { 
    delegate.set(name, value);
  }

  /**
   * @param name the payload name
   * @param type the expected payload type
   * @return the attached payload
   */
  public <T> T get(String name, java.lang.Class<T> type) { 
    T ret = (T)io.smallrye.mutiny.vertx.TypeArg.of(type).wrap(delegate.get(name, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type)));
    return ret;
  }

  public static  ProxyContext newInstance(io.vertx.httpproxy.ProxyContext arg) {
    return arg != null ? new ProxyContext(arg) : null;
  }

}
