package io.vertx.mutiny.httpproxy;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;

/**
 * A {@link io.vertx.mutiny.httpproxy.HttpProxy} interceptor.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyInterceptor original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.httpproxy.ProxyInterceptor.class)
public interface ProxyInterceptor {

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.httpproxy.ProxyResponse> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.httpproxy.ProxyResponse>(o1 -> io.vertx.mutiny.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());
  io.vertx.httpproxy.ProxyInterceptor getDelegate();

  /**
   * @param context the proxy context
   * @return when the request has actually been sent to the origin
   */
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.httpproxy.ProxyResponse> handleProxyRequest(io.vertx.mutiny.httpproxy.ProxyContext context);

  /**
   * @param context the proxy context
   * @return when the response has actually been sent to the user-agent
   */
  public io.smallrye.mutiny.Uni<Void> handleProxyResponse(io.vertx.mutiny.httpproxy.ProxyContext context);

  public static  ProxyInterceptor newInstance(io.vertx.httpproxy.ProxyInterceptor arg) {
    return arg != null ? new ProxyInterceptorImpl(arg) : null;
  }

}

class ProxyInterceptorImpl implements ProxyInterceptor {
  private final io.vertx.httpproxy.ProxyInterceptor delegate;
  
  public io.vertx.httpproxy.ProxyInterceptor getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ProxyInterceptorImpl() {
    this.delegate = null;
  }

  public ProxyInterceptorImpl(io.vertx.httpproxy.ProxyInterceptor delegate) {
    this.delegate = delegate;
  }

  /**
   * Handle the proxy request at the stage of this interceptor.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param context the proxy context
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.httpproxy.ProxyResponse> handleProxyRequest(io.vertx.mutiny.httpproxy.ProxyContext context) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.handleProxyRequest(context.getDelegate()).map(x -> ProxyResponse.newInstance(x)));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyRequest(io.vertx.mutiny.httpproxy.ProxyContext)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param context the proxy context
   * @return the ProxyResponse instance produced by the operation.
   */
  public io.vertx.mutiny.httpproxy.ProxyResponse handleProxyRequestAndAwait(io.vertx.mutiny.httpproxy.ProxyContext context) { 
    return handleProxyRequest(context).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyRequest(io.vertx.mutiny.httpproxy.ProxyContext)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyRequest(io.vertx.mutiny.httpproxy.ProxyContext)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyRequest(io.vertx.mutiny.httpproxy.ProxyContext)} but you don't need to compose it with other operations.
   * @param context the proxy context
   */
  public void handleProxyRequestAndForget(io.vertx.mutiny.httpproxy.ProxyContext context) { 
    handleProxyRequest(context).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * Handle the proxy response at the stage of this interceptor.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param context the proxy context
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> handleProxyResponse(io.vertx.mutiny.httpproxy.ProxyContext context) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.handleProxyResponse(context.getDelegate()));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyResponse(io.vertx.mutiny.httpproxy.ProxyContext)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param context the proxy context
   * @return the Void instance produced by the operation.
   */
  public Void handleProxyResponseAndAwait(io.vertx.mutiny.httpproxy.ProxyContext context) { 
    return handleProxyResponse(context).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyResponse(io.vertx.mutiny.httpproxy.ProxyContext)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyResponse(io.vertx.mutiny.httpproxy.ProxyContext)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyInterceptor#handleProxyResponse(io.vertx.mutiny.httpproxy.ProxyContext)} but you don't need to compose it with other operations.
   * @param context the proxy context
   */
  public void handleProxyResponseAndForget(io.vertx.mutiny.httpproxy.ProxyContext context) { 
    handleProxyResponse(context).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


}
