package io.vertx.mutiny.httpproxy;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.Future;

/**
 *
 * Handles the interoperability of the <b>request</b> between the <i><b>user agent</b></i> and the <i><b>origin</b></i>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyRequest original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.httpproxy.ProxyRequest.class)
public class ProxyRequest {

  public static final io.smallrye.mutiny.vertx.TypeArg<ProxyRequest> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ProxyRequest((io.vertx.httpproxy.ProxyRequest) obj),
    ProxyRequest::getDelegate
  );

  private final io.vertx.httpproxy.ProxyRequest delegate;
  
  public ProxyRequest(io.vertx.httpproxy.ProxyRequest delegate) {
    this.delegate = delegate;
  }

  public ProxyRequest(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyRequest)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ProxyRequest() {
    this.delegate = null;
  }

  public io.vertx.httpproxy.ProxyRequest getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.httpproxy.ProxyResponse> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.httpproxy.ProxyResponse>(o1 -> io.vertx.mutiny.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxyRequest that = (ProxyRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param proxiedRequest the <code>HttpServerRequest</code> that is proxied
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.mutiny.httpproxy.ProxyRequest reverseProxy(io.vertx.mutiny.core.http.HttpServerRequest proxiedRequest) { 
    io.vertx.mutiny.httpproxy.ProxyRequest ret = io.vertx.mutiny.httpproxy.ProxyRequest.newInstance((io.vertx.httpproxy.ProxyRequest)io.vertx.httpproxy.ProxyRequest.reverseProxy(proxiedRequest.getDelegate()));
    return ret;
  }

  /**
   * @return the HTTP version of the proxied request
   */
  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the absolute URI of the proxied request
   */
  public String absoluteURI() { 
    String ret = delegate.absoluteURI();
    return ret;
  }

  /**
   * @return the HTTP method to be sent to the <i><b>origin</b></i> server.
   */
  public io.vertx.core.http.HttpMethod getMethod() { 
    io.vertx.core.http.HttpMethod ret = delegate.getMethod();
    return ret;
  }

  /**
   * @param method the new HTTP method
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyRequest setMethod(io.vertx.core.http.HttpMethod method) { 
    delegate.setMethod(method);
    return this;
  }

  /**
   * @return the request URI to be sent to the <i><b>origin</b></i> server.
   */
  public String getURI() { 
    String ret = delegate.getURI();
    return ret;
  }

  /**
   * @param uri the new URI
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyRequest setURI(String uri) { 
    delegate.setURI(uri);
    return this;
  }

  /**
   * @return the request body to be sent to the <i><b>origin</b></i> server.
   */
  public io.vertx.mutiny.httpproxy.Body getBody() { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)delegate.getBody());
    return ret;
  }

  /**
   * @param body the new body
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyRequest setBody(io.vertx.mutiny.httpproxy.Body body) { 
    delegate.setBody(body.getDelegate());
    return this;
  }

  /**
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyRequest setAuthority(String authority) { 
    delegate.setAuthority(authority);
    return this;
  }

  /**
   * @return the request authority, for HTTP2 the  pseudo header otherwise the  header
   */
  public String getAuthority() { 
    String ret = delegate.getAuthority();
    return ret;
  }

  /**
   * @return the headers that will be sent to the origin server, the returned headers can be modified. The headers map is populated with the proxied request headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Proxy this request to the <i><b>origin</b></i> server using the specified <code>request</code> and then send the proxy response.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param request the request connected to the <i><b>origin</b></i> server
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> proxy(io.vertx.mutiny.core.http.HttpClientRequest request) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.proxy(request.getDelegate()));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyRequest#proxy(io.vertx.mutiny.core.http.HttpClientRequest)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param request the request connected to the <i><b>origin</b></i> server
   * @return the Void instance produced by the operation.
   */
  public Void proxyAndAwait(io.vertx.mutiny.core.http.HttpClientRequest request) { 
    return proxy(request).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyRequest#proxy(io.vertx.mutiny.core.http.HttpClientRequest)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyRequest#proxy(io.vertx.mutiny.core.http.HttpClientRequest)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyRequest#proxy(io.vertx.mutiny.core.http.HttpClientRequest)} but you don't need to compose it with other operations.
   * @param request the request connected to the <i><b>origin</b></i> server
   */
  public void proxyAndForget(io.vertx.mutiny.core.http.HttpClientRequest request) { 
    proxy(request).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * Send this request to the <i><b>origin</b></i> server using the specified <code>request</code>.
   *
   * <p> The returned future will be completed with the proxy response returned by the <i><b>origin</b></i>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param request the request connected to the <i><b>origin</b></i> server
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.httpproxy.ProxyResponse> send(io.vertx.mutiny.core.http.HttpClientRequest request) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.send(request.getDelegate()).map(x -> ProxyResponse.newInstance(x)));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyRequest#send(io.vertx.mutiny.core.http.HttpClientRequest)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param request the request connected to the <i><b>origin</b></i> server
   * @return the ProxyResponse instance produced by the operation.
   */
  public io.vertx.mutiny.httpproxy.ProxyResponse sendAndAwait(io.vertx.mutiny.core.http.HttpClientRequest request) { 
    return send(request).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyRequest#send(io.vertx.mutiny.core.http.HttpClientRequest)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyRequest#send(io.vertx.mutiny.core.http.HttpClientRequest)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyRequest#send(io.vertx.mutiny.core.http.HttpClientRequest)} but you don't need to compose it with other operations.
   * @param request the request connected to the <i><b>origin</b></i> server
   */
  public void sendAndForget(io.vertx.mutiny.core.http.HttpClientRequest request) { 
    send(request).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyRequest release() { 
    delegate.release();
    return this;
  }

  /**
   * @return the proxied HTTP server request
   */
  public io.vertx.mutiny.core.http.HttpServerRequest proxiedRequest() { 
    io.vertx.mutiny.core.http.HttpServerRequest ret = io.vertx.mutiny.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)delegate.proxiedRequest());
    return ret;
  }

  /**
   * @return the proxy response
   */
  public io.vertx.mutiny.httpproxy.ProxyResponse response() { 
    io.vertx.mutiny.httpproxy.ProxyResponse ret = io.vertx.mutiny.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)delegate.response());
    return ret;
  }

  public static  ProxyRequest newInstance(io.vertx.httpproxy.ProxyRequest arg) {
    return arg != null ? new ProxyRequest(arg) : null;
  }

}
