package io.vertx.mutiny.httpproxy;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;

/**
 *
 * Handles the interoperability of the <b>response</b> between the <i><b>origin</b></i> and the <i><b>user agent</b></i>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyResponse original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.httpproxy.ProxyResponse.class)
public class ProxyResponse {

  public static final io.smallrye.mutiny.vertx.TypeArg<ProxyResponse> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ProxyResponse((io.vertx.httpproxy.ProxyResponse) obj),
    ProxyResponse::getDelegate
  );

  private final io.vertx.httpproxy.ProxyResponse delegate;
  
  public ProxyResponse(io.vertx.httpproxy.ProxyResponse delegate) {
    this.delegate = delegate;
  }

  public ProxyResponse(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyResponse)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ProxyResponse() {
    this.delegate = null;
  }

  public io.vertx.httpproxy.ProxyResponse getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxyResponse that = (ProxyResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the proxy request
   */
  public io.vertx.mutiny.httpproxy.ProxyRequest request() { 
    io.vertx.mutiny.httpproxy.ProxyRequest ret = io.vertx.mutiny.httpproxy.ProxyRequest.newInstance((io.vertx.httpproxy.ProxyRequest)delegate.request());
    return ret;
  }

  /**
   * @return the status code to be sent to the <i><b>user agent</b></i>
   */
  public int getStatusCode() { 
    int ret = delegate.getStatusCode();
    return ret;
  }

  /**
   * @param sc the status code
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyResponse setStatusCode(int sc) { 
    delegate.setStatusCode(sc);
    return this;
  }

  /**
   * @return the status message to be sent to the <i><b>user agent</b></i>
   */
  public String getStatusMessage() { 
    String ret = delegate.getStatusMessage();
    return ret;
  }

  /**
   * @param statusMessage the status message
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyResponse setStatusMessage(String statusMessage) { 
    delegate.setStatusMessage(statusMessage);
    return this;
  }

  /**
   * @return the headers that will be sent to the <i><b>user agent</b></i>, the returned headers can be modified. The headers map is populated with the proxied response headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * @return the response body to be sent to the <i><b>user agent</b></i>
   */
  public io.vertx.mutiny.httpproxy.Body getBody() { 
    io.vertx.mutiny.httpproxy.Body ret = io.vertx.mutiny.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)delegate.getBody());
    return ret;
  }

  /**
   * @param body the new body
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyResponse setBody(io.vertx.mutiny.httpproxy.Body body) { 
    delegate.setBody(body.getDelegate());
    return this;
  }

  public boolean publicCacheControl() { 
    boolean ret = delegate.publicCacheControl();
    return ret;
  }

  public long maxAge() { 
    long ret = delegate.maxAge();
    return ret;
  }

  /**
   * @return the <code>etag</code> sent by the <i><b>origin</b></i> response
   */
  public String etag() { 
    String ret = delegate.etag();
    return ret;
  }

  /**
   * Send the proxies response to the <i><b>user agent</b></i>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.send());}

  /**
   * Blocking variant of {@link io.vertx.mutiny.httpproxy.ProxyResponse#send}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait() { 
    return send().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.httpproxy.ProxyResponse#send} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.httpproxy.ProxyResponse#send}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.httpproxy.ProxyResponse#send} but you don't need to compose it with other operations.
   */
  public void sendAndForget() { 
    send().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @return the instance of ProxyResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.httpproxy.ProxyResponse release() { 
    delegate.release();
    return this;
  }

  public static  ProxyResponse newInstance(io.vertx.httpproxy.ProxyResponse arg) {
    return arg != null ? new ProxyResponse(arg) : null;
  }

}
