/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.httpproxy;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.mutiny.httpproxy.ProxyRequest;
import io.vertx.mutiny.httpproxy.ProxyResponse;

@MutinyGen(value=io.vertx.httpproxy.ProxyContext.class)
public class ProxyContext {
    public static final TypeArg<ProxyContext> __TYPE_ARG = new TypeArg(obj -> new ProxyContext((io.vertx.httpproxy.ProxyContext)obj), ProxyContext::getDelegate);
    private final io.vertx.httpproxy.ProxyContext delegate;
    static final TypeArg<ProxyResponse> TYPE_ARG_0 = new TypeArg(o1 -> ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());

    public ProxyContext(io.vertx.httpproxy.ProxyContext delegate) {
        this.delegate = delegate;
    }

    public ProxyContext(Object delegate) {
        this.delegate = (io.vertx.httpproxy.ProxyContext)delegate;
    }

    ProxyContext() {
        this.delegate = null;
    }

    public io.vertx.httpproxy.ProxyContext getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyContext that = (ProxyContext)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ProxyRequest request() {
        ProxyRequest ret = ProxyRequest.newInstance(this.delegate.request());
        return ret;
    }

    public ProxyResponse response() {
        ProxyResponse ret = ProxyResponse.newInstance(this.delegate.response());
        return ret;
    }

    @CheckReturnValue
    public Uni<ProxyResponse> sendRequest() {
        return UniHelper.toUni((Future)this.delegate.sendRequest().map(x -> ProxyResponse.newInstance(x)));
    }

    public ProxyResponse sendRequestAndAwait() {
        return (ProxyResponse)this.sendRequest().await().indefinitely();
    }

    public void sendRequestAndForget() {
        this.sendRequest().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> sendResponse() {
        return UniHelper.toUni((Future)this.delegate.sendResponse());
    }

    public Void sendResponseAndAwait() {
        return (Void)this.sendResponse().await().indefinitely();
    }

    public void sendResponseAndForget() {
        this.sendResponse().subscribe().with(UniHelper.NOOP);
    }

    public void set(String name, Object value) {
        this.delegate.set(name, value);
    }

    public <T> T get(String name, Class<T> type) {
        Object ret = TypeArg.of(type).wrap(this.delegate.get(name, MutinyHelper.unwrap(type)));
        return (T)ret;
    }

    public static ProxyContext newInstance(io.vertx.httpproxy.ProxyContext arg) {
        return arg != null ? new ProxyContext(arg) : null;
    }
}

