package io.vertx.mutiny.ext.jdbc;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous client interface for interacting with a JDBC compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.jdbc.JDBCClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.jdbc.JDBCClient.class)
public class JDBCClient extends io.vertx.mutiny.ext.sql.SQLClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<JDBCClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JDBCClient((io.vertx.ext.jdbc.JDBCClient) obj),
    JDBCClient::getDelegate
  );

  private final io.vertx.ext.jdbc.JDBCClient delegate;
  
  public JDBCClient(io.vertx.ext.jdbc.JDBCClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCClient(Object delegate) {
    super((io.vertx.ext.jdbc.JDBCClient)delegate);
    this.delegate = (io.vertx.ext.jdbc.JDBCClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JDBCClient() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.jdbc.JDBCClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCClient that = (JDBCClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingle(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.querySingle(sql, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleAndAwait(String sql) { 
    return (JsonArray) querySingle(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleAndForget(String sql) { 
    querySingle(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments) { 
    return (JsonArray) querySingleWithParams(sql, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments) { 
    querySingleWithParams(sql, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient create(io.vertx.mutiny.core.Vertx vertx, JsonObject config) { 
    io.vertx.mutiny.ext.jdbc.JDBCClient ret = io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)io.vertx.ext.jdbc.JDBCClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient createShared(io.vertx.mutiny.core.Vertx vertx, JsonObject config, String dataSourceName) { 
    io.vertx.mutiny.ext.jdbc.JDBCClient ret = io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient createShared(io.vertx.mutiny.core.Vertx vertx, JsonObject config) { 
    io.vertx.mutiny.ext.jdbc.JDBCClient ret = io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * The default data source provider is C3P0
   */
  public static final String DEFAULT_PROVIDER_CLASS = io.vertx.ext.jdbc.JDBCClient.DEFAULT_PROVIDER_CLASS;
  /**
   * The name of the default data source
   */
  public static final String DEFAULT_DS_NAME = io.vertx.ext.jdbc.JDBCClient.DEFAULT_DS_NAME;
  public static  JDBCClient newInstance(io.vertx.ext.jdbc.JDBCClient arg) {
    return arg != null ? new JDBCClient(arg) : null;
  }

}
