package io.vertx.mutiny.ext.sql;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.ext.sql.UpdateResult;
import java.io.Closeable;
import io.vertx.ext.sql.ResultSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a connection to a SQL database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.sql.SQLConnection.class)
public class SQLConnection implements io.vertx.mutiny.ext.sql.SQLOperations {

  public static final io.smallrye.mutiny.vertx.TypeArg<SQLConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SQLConnection((io.vertx.ext.sql.SQLConnection) obj),
    SQLConnection::getDelegate
  );

  private final io.vertx.ext.sql.SQLConnection delegate;
  
  public SQLConnection(io.vertx.ext.sql.SQLConnection delegate) {
    this.delegate = delegate;
  }

  public SQLConnection(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SQLConnection() {
    this.delegate = null;
  }

  public io.vertx.ext.sql.SQLConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLConnection that = (SQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingle(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.querySingle(sql, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleAndAwait(String sql) { 
    return (JsonArray) querySingle(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleAndForget(String sql) { 
    querySingle(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments) { 
    return (JsonArray) querySingleWithParams(sql, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments) { 
    querySingleWithParams(sql, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param options the options to modify the unwrapped connection.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection setOptions(io.vertx.ext.sql.SQLOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Sets the auto commit flag for this connection. True by default.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param autoCommit the autoCommit flag, true by default.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> setAutoCommit(boolean autoCommit) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.setAutoCommit(autoCommit, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#setAutoCommit(boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param autoCommit the autoCommit flag, true by default.
   * @return the Void instance produced by the operation.
   */
  public Void setAutoCommitAndAwait(boolean autoCommit) { 
    return (Void) setAutoCommit(autoCommit).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#setAutoCommit(boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#setAutoCommit(boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#setAutoCommit(boolean)} but you don't need to compose it with other operations.
   * @param autoCommit the autoCommit flag, true by default.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection setAutoCommitAndForget(boolean autoCommit) { 
    setAutoCommit(autoCommit).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL statement
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> execute(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.execute(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#execute(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return the Void instance produced by the operation.
   */
  public Void executeAndAwait(String sql) { 
    return (Void) execute(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#execute(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#execute(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#execute(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection executeAndForget(String sql) { 
    execute(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> query(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.query(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#query(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet queryAndAwait(String sql) { 
    return (io.vertx.ext.sql.ResultSet) query(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#query(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#query(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#query(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection queryAndForget(String sql) { 
    query(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.sql.SQLRowStream> queryStream(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.queryStream(sql, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStream(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the SQLRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream queryStreamAndAwait(String sql) { 
    return (io.vertx.mutiny.ext.sql.SQLRowStream) queryStream(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStream(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStream(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStream(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection queryStreamAndForget(String sql) { 
    queryStream(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> queryWithParams(String sql, JsonArray params) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queryWithParams(sql, params, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet queryWithParamsAndAwait(String sql, JsonArray params) { 
    return (io.vertx.ext.sql.ResultSet) queryWithParams(sql, params).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#queryWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection queryWithParamsAndForget(String sql, JsonArray params) { 
    queryWithParams(sql, params).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.sql.SQLRowStream> queryStreamWithParams(String sql, JsonArray params) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.queryStreamWithParams(sql, params, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStreamWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the SQLRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream queryStreamWithParamsAndAwait(String sql, JsonArray params) { 
    return (io.vertx.mutiny.ext.sql.SQLRowStream) queryStreamWithParams(sql, params).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStreamWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStreamWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#queryStreamWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection queryStreamWithParamsAndForget(String sql, JsonArray params) { 
    queryStreamWithParams(sql, params).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.UpdateResult> update(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.update(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#update(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the UpdateResult instance produced by the operation.
   */
  public io.vertx.ext.sql.UpdateResult updateAndAwait(String sql) { 
    return (io.vertx.ext.sql.UpdateResult) update(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#update(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#update(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#update(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection updateAndForget(String sql) { 
    update(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.UpdateResult> updateWithParams(String sql, JsonArray params) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateWithParams(sql, params, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#updateWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the UpdateResult instance produced by the operation.
   */
  public io.vertx.ext.sql.UpdateResult updateWithParamsAndAwait(String sql, JsonArray params) { 
    return (io.vertx.ext.sql.UpdateResult) updateWithParams(sql, params).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#updateWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#updateWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#updateWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection updateWithParamsAndForget(String sql, JsonArray params) { 
    updateWithParams(sql, params).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> call(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.call(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#call(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet callAndAwait(String sql) { 
    return (io.vertx.ext.sql.ResultSet) call(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#call(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#call(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#call(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection callAndForget(String sql) { 
    call(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> callWithParams(String sql, JsonArray params, JsonArray outputs) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.callWithParams(sql, params, outputs, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#callWithParams(String,JsonArray,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet callWithParamsAndAwait(String sql, JsonArray params, JsonArray outputs) { 
    return (io.vertx.ext.sql.ResultSet) callWithParams(sql, params, outputs).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#callWithParams(String,JsonArray,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#callWithParams(String,JsonArray,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#callWithParams(String,JsonArray,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection callWithParamsAndForget(String sql, JsonArray params, JsonArray outputs) { 
    callWithParams(sql, params, outputs).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Commits all changes made since the previous commit/rollback.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> commit() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.commit(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#commit}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void commitAndAwait() { 
    return (Void) commit().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#commit} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#commit}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#commit} but you don't need to compose it with other operations.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection commitAndForget() { 
    commit().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Rolls back all changes made since the previous commit/rollback.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> rollback() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rollback(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#rollback}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void rollbackAndAwait() { 
    return (Void) rollback().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#rollback} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#rollback}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#rollback} but you don't need to compose it with other operations.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection rollbackAndForget() { 
    rollback().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param timeoutInSeconds the max amount of seconds the query can take to execute.
   * @return the instance of SQLConnection to chain method calls.
   * @deprecated instead use {@link #setOptions(SQLOptions)} with {@link SQLOptions#setQueryTimeout(int)}   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection setQueryTimeout(int timeoutInSeconds) { 
    delegate.setQueryTimeout(timeoutInSeconds);
    return this;
  }

  /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sqlStatements sql statement
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<Integer>> batch(List<String> sqlStatements) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.batch(sqlStatements, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#batch(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sqlStatements sql statement
   * @return the List<Integer> instance produced by the operation.
   */
  public List<Integer> batchAndAwait(List<String> sqlStatements) { 
    return (List<Integer>) batch(sqlStatements).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#batch(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#batch(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#batch(List)} but you don't need to compose it with other operations.
   * @param sqlStatements sql statement
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection batchAndForget(List<String> sqlStatements) { 
    batch(sqlStatements).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<Integer>> batchWithParams(String sqlStatement, List<JsonArray> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.batchWithParams(sqlStatement, args, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#batchWithParams(String,List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return the List<Integer> instance produced by the operation.
   */
  public List<Integer> batchWithParamsAndAwait(String sqlStatement, List<JsonArray> args) { 
    return (List<Integer>) batchWithParams(sqlStatement, args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#batchWithParams(String,List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#batchWithParams(String,List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#batchWithParams(String,List)} but you don't need to compose it with other operations.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection batchWithParamsAndForget(String sqlStatement, List<JsonArray> args) { 
    batchWithParams(sqlStatement, args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<Integer>> batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#batchCallableWithParams(String,List,List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return the List<Integer> instance produced by the operation.
   */
  public List<Integer> batchCallableWithParamsAndAwait(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) { 
    return (List<Integer>) batchCallableWithParams(sqlStatement, inArgs, outArgs).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#batchCallableWithParams(String,List,List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#batchCallableWithParams(String,List,List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#batchCallableWithParams(String,List,List)} but you don't need to compose it with other operations.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection batchCallableWithParamsAndForget(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) { 
    batchCallableWithParams(sqlStatement, inArgs, outArgs).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param isolation the level of isolation
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> setTransactionIsolation(io.vertx.ext.sql.TransactionIsolation isolation) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setTransactionIsolation(isolation, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#setTransactionIsolation(TransactionIsolation)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param isolation the level of isolation
   * @return the Void instance produced by the operation.
   */
  public Void setTransactionIsolationAndAwait(io.vertx.ext.sql.TransactionIsolation isolation) { 
    return (Void) setTransactionIsolation(isolation).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#setTransactionIsolation(TransactionIsolation)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#setTransactionIsolation(TransactionIsolation)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#setTransactionIsolation(TransactionIsolation)} but you don't need to compose it with other operations.
   * @param isolation the level of isolation
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection setTransactionIsolationAndForget(io.vertx.ext.sql.TransactionIsolation isolation) { 
    setTransactionIsolation(isolation).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.TransactionIsolation> getTransactionIsolation() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getTransactionIsolation(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#getTransactionIsolation}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the TransactionIsolation instance produced by the operation.
   */
  public io.vertx.ext.sql.TransactionIsolation getTransactionIsolationAndAwait() { 
    return (io.vertx.ext.sql.TransactionIsolation) getTransactionIsolation().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLConnection#getTransactionIsolation} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLConnection#getTransactionIsolation}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLConnection#getTransactionIsolation} but you don't need to compose it with other operations.
   * @return the instance of SQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLConnection getTransactionIsolationAndForget() { 
    getTransactionIsolation().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  SQLConnection newInstance(io.vertx.ext.sql.SQLConnection arg) {
    return arg != null ? new SQLConnection(arg) : null;
  }

}
