package io.vertx.mutiny.ext.sql;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.ResultSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a SQL query interface to a database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLOperations original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.sql.SQLOperations.class)
public interface SQLOperations {

  io.vertx.ext.sql.SQLOperations getDelegate();

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> query(String sql);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet queryAndAwait(String sql);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryAndForget(String sql);

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> queryWithParams(String sql, JsonArray params);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet queryWithParamsAndAwait(String sql, JsonArray params);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryWithParamsAndForget(String sql, JsonArray params);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.sql.SQLRowStream> queryStream(String sql);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the SQLRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream queryStreamAndAwait(String sql);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryStreamAndForget(String sql);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.sql.SQLRowStream> queryStreamWithParams(String sql, JsonArray params);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the SQLRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream queryStreamWithParamsAndAwait(String sql, JsonArray params);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryStreamWithParamsAndForget(String sql, JsonArray params);

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingle(String sql);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleAndAwait(String sql);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleAndForget(String sql);

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments);

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.UpdateResult> update(String sql);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the UpdateResult instance produced by the operation.
   */
  public io.vertx.ext.sql.UpdateResult updateAndAwait(String sql);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations updateAndForget(String sql);

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.UpdateResult> updateWithParams(String sql, JsonArray params);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the UpdateResult instance produced by the operation.
   */
  public io.vertx.ext.sql.UpdateResult updateWithParamsAndAwait(String sql, JsonArray params);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations updateWithParamsAndForget(String sql, JsonArray params);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> call(String sql);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet callAndAwait(String sql);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations callAndForget(String sql);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> callWithParams(String sql, JsonArray params, JsonArray outputs);

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet callWithParamsAndAwait(String sql, JsonArray params, JsonArray outputs);

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations callWithParamsAndForget(String sql, JsonArray params, JsonArray outputs);

  public static  SQLOperations newInstance(io.vertx.ext.sql.SQLOperations arg) {
    return arg != null ? new SQLOperationsImpl(arg) : null;
  }

}

class SQLOperationsImpl implements SQLOperations {
  private final io.vertx.ext.sql.SQLOperations delegate;
  
  public io.vertx.ext.sql.SQLOperations getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SQLOperationsImpl() {
    this.delegate = null;
  }

  public SQLOperationsImpl(io.vertx.ext.sql.SQLOperations delegate) {
    this.delegate = delegate;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> query(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.query(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet queryAndAwait(String sql) { 
    return (io.vertx.ext.sql.ResultSet) query(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#query(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryAndForget(String sql) { 
    query(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> queryWithParams(String sql, JsonArray params) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queryWithParams(sql, params, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet queryWithParamsAndAwait(String sql, JsonArray params) { 
    return (io.vertx.ext.sql.ResultSet) queryWithParams(sql, params).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#queryWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryWithParamsAndForget(String sql, JsonArray params) { 
    queryWithParams(sql, params).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.sql.SQLRowStream> queryStream(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.queryStream(sql, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the SQLRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream queryStreamAndAwait(String sql) { 
    return (io.vertx.mutiny.ext.sql.SQLRowStream) queryStream(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStream(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryStreamAndForget(String sql) { 
    queryStream(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.sql.SQLRowStream> queryStreamWithParams(String sql, JsonArray params) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.queryStreamWithParams(sql, params, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the SQLRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream queryStreamWithParamsAndAwait(String sql, JsonArray params) { 
    return (io.vertx.mutiny.ext.sql.SQLRowStream) queryStreamWithParams(sql, params).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#queryStreamWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations queryStreamWithParamsAndForget(String sql, JsonArray params) { 
    queryStreamWithParams(sql, params).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingle(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.querySingle(sql, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleAndAwait(String sql) { 
    return (JsonArray) querySingle(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingle(String)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleAndForget(String sql) { 
    querySingle(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the JsonArray instance produced by the operation.
   */
  public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments) { 
    return (JsonArray) querySingleWithParams(sql, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#querySingleWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments) { 
    querySingleWithParams(sql, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.UpdateResult> update(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.update(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the UpdateResult instance produced by the operation.
   */
  public io.vertx.ext.sql.UpdateResult updateAndAwait(String sql) { 
    return (io.vertx.ext.sql.UpdateResult) update(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#update(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations updateAndForget(String sql) { 
    update(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.UpdateResult> updateWithParams(String sql, JsonArray params) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateWithParams(sql, params, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the UpdateResult instance produced by the operation.
   */
  public io.vertx.ext.sql.UpdateResult updateWithParamsAndAwait(String sql, JsonArray params) { 
    return (io.vertx.ext.sql.UpdateResult) updateWithParams(sql, params).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#updateWithParams(String,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations updateWithParamsAndForget(String sql, JsonArray params) { 
    updateWithParams(sql, params).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> call(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.call(sql, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet callAndAwait(String sql) { 
    return (io.vertx.ext.sql.ResultSet) call(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#call(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations callAndForget(String sql) { 
    call(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.sql.ResultSet> callWithParams(String sql, JsonArray params, JsonArray outputs) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.callWithParams(sql, params, outputs, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.ext.sql.ResultSet callWithParamsAndAwait(String sql, JsonArray params, JsonArray outputs) { 
    return (io.vertx.ext.sql.ResultSet) callWithParams(sql, params, outputs).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLOperations#callWithParams(String,JsonArray,JsonArray)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return the instance of SQLOperations to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.sql.SQLOperations callWithParamsAndForget(String sql, JsonArray params, JsonArray outputs) { 
    callWithParams(sql, params, outputs).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

}
