package io.vertx.mutiny.ext.sql;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A ReadStream of Rows from the underlying RDBMS. This class follows the ReadStream semantics and will automatically
 * close the underlying resources if all returned rows are returned. For cases where the results are ignored before the
 * full processing of the returned rows is complete the close method **MUST** be called in order to release underlying
 * resources.
 *
 * The interface is minimal in order to support all SQL clients not just JDBC.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLRowStream original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.sql.SQLRowStream.class)
public class SQLRowStream implements io.vertx.mutiny.core.streams.ReadStream<JsonArray> {

  public static final io.smallrye.mutiny.vertx.TypeArg<SQLRowStream> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SQLRowStream((io.vertx.ext.sql.SQLRowStream) obj),
    SQLRowStream::getDelegate
  );

  private final io.vertx.ext.sql.SQLRowStream delegate;
  
  public SQLRowStream(io.vertx.ext.sql.SQLRowStream delegate) {
    this.delegate = delegate;
  }

  public SQLRowStream(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLRowStream)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SQLRowStream() {
    this.delegate = null;
  }

  public io.vertx.ext.sql.SQLRowStream getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLRowStream that = (SQLRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Fluent
  public io.vertx.mutiny.core.streams.ReadStream<JsonArray> fetch(long arg0) { 
    delegate.fetch(arg0);
    return this;
  }

  public io.vertx.mutiny.core.streams.Pipe<JsonArray> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<JsonArray> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<JsonArray> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<JsonArray> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<JsonArray> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.ext.sql.SQLRowStream __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.ext.sql.SQLRowStream exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.ext.sql.SQLRowStream __handler(Handler<JsonArray> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.mutiny.ext.sql.SQLRowStream handler(java.util.function.Consumer<JsonArray> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.ext.sql.SQLRowStream pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.ext.sql.SQLRowStream resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  private io.vertx.mutiny.ext.sql.SQLRowStream __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.ext.sql.SQLRowStream endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @param name the column name
   * @return the json array index
   */
  public int column(String name) { 
    int ret = delegate.column(name);
    return ret;
  }

  /**
   * @return the list of columns names returned by the query
   */
  public List<String> columns() { 
    List<String> ret = delegate.columns();
    return ret;
  }

  /**
   * @param handler called when the current result set is closed
   * @return the instance of SQLRowStream to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.ext.sql.SQLRowStream __resultSetClosedHandler(Handler<Void> handler) { 
    delegate.resultSetClosedHandler(handler);
    return this;
  }

  /**
   * @param handler called when the current result set is closed
   * @return 
   */
  public io.vertx.mutiny.ext.sql.SQLRowStream resultSetClosedHandler(java.lang.Runnable handler) {
    return __resultSetClosedHandler(ignored -> handler.run()
);
  }

  /**
   */
  public void moreResults() { 
    delegate.moreResults();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.sql.SQLRowStream#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.sql.SQLRowStream#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.sql.SQLRowStream#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.sql.SQLRowStream#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  private Multi<JsonArray> multi;

  @CheckReturnValue
  public synchronized Multi<JsonArray> toMulti() {
    if (multi == null) {
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(this.getDelegate());    }
    return multi;
  }

  public java.lang.Iterable<JsonArray> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<JsonArray> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  SQLRowStream newInstance(io.vertx.ext.sql.SQLRowStream arg) {
    return arg != null ? new SQLRowStream(arg) : null;
  }

}
