package io.vertx.mutiny.jdbcclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import javax.sql.DataSource;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.PoolOptions;

/**
 * JDBCPool is the interface that allows using the Sql Client API with plain JDBC.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.jdbcclient.JDBCPool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.jdbcclient.JDBCPool.class)
public class JDBCPool extends io.vertx.mutiny.sqlclient.Pool {

  public static final io.smallrye.mutiny.vertx.TypeArg<JDBCPool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JDBCPool((io.vertx.jdbcclient.JDBCPool) obj),
    JDBCPool::getDelegate
  );

  private final io.vertx.jdbcclient.JDBCPool delegate;
  
  public JDBCPool(io.vertx.jdbcclient.JDBCPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCPool(Object delegate) {
    super((io.vertx.jdbcclient.JDBCPool)delegate);
    this.delegate = (io.vertx.jdbcclient.JDBCPool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JDBCPool() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.jdbcclient.JDBCPool getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCPool that = (JDBCPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vert.x instance
   * @param connectOptions the options to configure the connection
   * @param poolOptions the connection pool options
   * @return the client
   */
  public static io.vertx.mutiny.jdbcclient.JDBCPool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.jdbcclient.JDBCConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.jdbcclient.JDBCPool ret = io.vertx.mutiny.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the options to configure the client using the same format as {@link io.vertx.mutiny.ext.jdbc.JDBCClient}
   * @return the client
   */
  public static io.vertx.mutiny.jdbcclient.JDBCPool pool(io.vertx.mutiny.core.Vertx vertx, JsonObject config) { 
    io.vertx.mutiny.jdbcclient.JDBCPool ret = io.vertx.mutiny.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param dataSourceProvider the options to configure the client using the same format as {@link io.vertx.mutiny.ext.jdbc.JDBCClient}
   * @return the client
   */
  public static io.vertx.mutiny.jdbcclient.JDBCPool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.jdbc.spi.DataSourceProvider dataSourceProvider) { 
    io.vertx.mutiny.jdbcclient.JDBCPool ret = io.vertx.mutiny.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), dataSourceProvider));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param dataSource a pre-initialized data source
   * @return the client
   */
  public static io.vertx.mutiny.jdbcclient.JDBCPool pool(io.vertx.mutiny.core.Vertx vertx, javax.sql.DataSource dataSource) { 
    io.vertx.mutiny.jdbcclient.JDBCPool ret = io.vertx.mutiny.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), dataSource));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param dataSource a pre-initialized data source
   * @param config the pool configuration
   * @return the client
   */
  public static io.vertx.mutiny.jdbcclient.JDBCPool pool(io.vertx.mutiny.core.Vertx vertx, javax.sql.DataSource dataSource, JsonObject config) { 
    io.vertx.mutiny.jdbcclient.JDBCPool ret = io.vertx.mutiny.jdbcclient.JDBCPool.newInstance((io.vertx.jdbcclient.JDBCPool)io.vertx.jdbcclient.JDBCPool.pool(vertx.getDelegate(), dataSource, config));
    return ret;
  }

  /**
   * The property to be used to retrieve the generated keys
   */
  public static final io.vertx.mutiny.sqlclient.PropertyKind<io.vertx.mutiny.sqlclient.Row> GENERATED_KEYS = io.vertx.mutiny.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.jdbcclient.JDBCPool.GENERATED_KEYS, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o0 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o0), o0 -> o0.getDelegate()));
  /**
   * The property to be used to retrieve the output of the callable statement
   */
  public static final io.vertx.mutiny.sqlclient.PropertyKind<Boolean> OUTPUT = io.vertx.mutiny.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.jdbcclient.JDBCPool.OUTPUT, TypeArg.unknown());
  public static  JDBCPool newInstance(io.vertx.jdbcclient.JDBCPool arg) {
    return arg != null ? new JDBCPool(arg) : null;
  }

}
