package io.vertx.mutiny.jdbcclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.sql.JDBCType;

/**
 * Tag if a parameter is of type OUT or INOUT.
 *
 * By default parameters are of type IN as they are provided by the user to the RDBMs engine. There are however cases
 * where these must be tagged as OUT/INOUT when dealing with stored procedures/functions or complex statements.
 *
 * This interface allows marking the type of the param as required by the JDBC API.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.jdbcclient.SqlOutParam original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.jdbcclient.SqlOutParam.class)
public class SqlOutParam {

  public static final io.smallrye.mutiny.vertx.TypeArg<SqlOutParam> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SqlOutParam((io.vertx.jdbcclient.SqlOutParam) obj),
    SqlOutParam::getDelegate
  );

  private final io.vertx.jdbcclient.SqlOutParam delegate;
  
  public SqlOutParam(io.vertx.jdbcclient.SqlOutParam delegate) {
    this.delegate = delegate;
  }

  public SqlOutParam(Object delegate) {
    this.delegate = (io.vertx.jdbcclient.SqlOutParam)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SqlOutParam() {
    this.delegate = null;
  }

  public io.vertx.jdbcclient.SqlOutParam getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlOutParam that = (SqlOutParam) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.mutiny.jdbcclient.SqlOutParam OUT(int out) { 
    io.vertx.mutiny.jdbcclient.SqlOutParam ret = io.vertx.mutiny.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.OUT(out));
    return ret;
  }

  /**
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.mutiny.jdbcclient.SqlOutParam OUT(String out) { 
    io.vertx.mutiny.jdbcclient.SqlOutParam ret = io.vertx.mutiny.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.OUT(out));
    return ret;
  }

  /**
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.mutiny.jdbcclient.SqlOutParam OUT(java.sql.JDBCType out) { 
    io.vertx.mutiny.jdbcclient.SqlOutParam ret = io.vertx.mutiny.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.OUT(out));
    return ret;
  }

  /**
   * @param in the value to be passed as input.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.mutiny.jdbcclient.SqlOutParam INOUT(java.lang.Object in, int out) { 
    io.vertx.mutiny.jdbcclient.SqlOutParam ret = io.vertx.mutiny.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.INOUT(in, out));
    return ret;
  }

  /**
   * @param in the value to be passed as input.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.mutiny.jdbcclient.SqlOutParam INOUT(java.lang.Object in, String out) { 
    io.vertx.mutiny.jdbcclient.SqlOutParam ret = io.vertx.mutiny.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.INOUT(in, out));
    return ret;
  }

  /**
   * @param in the value to be passed as input.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.mutiny.jdbcclient.SqlOutParam INOUT(java.lang.Object in, java.sql.JDBCType out) { 
    io.vertx.mutiny.jdbcclient.SqlOutParam ret = io.vertx.mutiny.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.INOUT(in, out));
    return ret;
  }

  /**
   * @return true if <code>INOUT</code>
   */
  public boolean in() { 
    boolean ret = delegate.in();
    return ret;
  }

  /**
   * @return type
   */
  public int type() { 
    int ret = delegate.type();
    return ret;
  }

  /**
   * @return input
   */
  public java.lang.Object value() { 
    java.lang.Object ret = (Object) delegate.value();
    return ret;
  }

  public static  SqlOutParam newInstance(io.vertx.jdbcclient.SqlOutParam arg) {
    return arg != null ? new SqlOutParam(arg) : null;
  }

}
