package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;

/**
 * Interface representing a <a href="https://json-schema.org/">Json Schema</a> <br/>
 * <p>
 * A schema could have two states: <br/>
 * <ul>
 *   <li>Synchronous: The validators tree can provide a synchronous validation, so you can validate your json both using  and </li>
 *   <li>Asynchronous: One or more branches of the validator tree requires an asynchronous validation, so you must use  to validate your json. If you use  it will throw a {@link io.vertx.json.schema.NoSyncValidationException}</li>
 * </ul>
 * <p>
 * To check the schema state you can use method . Note that invoking {@link io.vertx.mutiny.json.schema.Schema#validateAsync} generally doesn't have any additional overhead than invoking {@link io.vertx.mutiny.json.schema.Schema#validateSync}. <br/>
 * The schema can mutate the state in time, e.g. if you have a schema that is asynchronous because of a <code>$ref</code>,
 * after the first validation the external schema is cached inside {@link io.vertx.mutiny.json.schema.SchemaRouter} and this schema will switch to synchronous state<br/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.Schema original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.Schema.class)
public class Schema {

  public static final io.smallrye.mutiny.vertx.TypeArg<Schema> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Schema((io.vertx.json.schema.Schema) obj),
    Schema::getDelegate
  );

  private final io.vertx.json.schema.Schema delegate;
  
  public Schema(io.vertx.json.schema.Schema delegate) {
    this.delegate = delegate;
  }

  public Schema(Object delegate) {
    this.delegate = (io.vertx.json.schema.Schema)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Schema() {
    this.delegate = null;
  }

  public io.vertx.json.schema.Schema getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Schema that = (Schema) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Validate the json performing an asynchronous validation.<br/>
   * <p>
   * Note: If the schema is synchronous, this method will call internally 
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param json input to validate
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> validateAsync(java.lang.Object json) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.validateAsync(json));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.json.schema.Schema#validateAsync(Object)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param json input to validate
   * @return the Void instance produced by the operation.
   */
  public Void validateAsyncAndAwait(java.lang.Object json) { 
    return validateAsync(json).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.json.schema.Schema#validateAsync(Object)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.json.schema.Schema#validateAsync(Object)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.json.schema.Schema#validateAsync(Object)} but you don't need to compose it with other operations.
   * @param json input to validate
   */
  public void validateAsyncAndForget(java.lang.Object json) { 
    validateAsync(json).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @param json input to validate
   */
  public void validateSync(java.lang.Object json) { 
    delegate.validateSync(json);
  }

  /**
   * @return scope of this schema
   */
  public io.vertx.mutiny.core.json.pointer.JsonPointer getScope() { 
    io.vertx.mutiny.core.json.pointer.JsonPointer ret = io.vertx.mutiny.core.json.pointer.JsonPointer.newInstance((io.vertx.core.json.pointer.JsonPointer)delegate.getScope());
    return ret;
  }

  /**
   * @return Json representation of the schema
   */
  public java.lang.Object getJson() { 
    java.lang.Object ret = (Object) delegate.getJson();
    return ret;
  }

  /**
   * @return true if this validator can provide a synchronous validation.
   */
  public boolean isSync() { 
    boolean ret = delegate.isSync();
    return ret;
  }

  public static  Schema newInstance(io.vertx.json.schema.Schema arg) {
    return arg != null ? new Schema(arg) : null;
  }

}
