package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Predicate;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.common.ValidatorFactory;

/**
 * Parse a Json Schema. The parser can be extended to support custom keywords using 
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.SchemaParser original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.SchemaParser.class)
public class SchemaParser {

  public static final io.smallrye.mutiny.vertx.TypeArg<SchemaParser> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SchemaParser((io.vertx.json.schema.SchemaParser) obj),
    SchemaParser::getDelegate
  );

  private final io.vertx.json.schema.SchemaParser delegate;
  
  public SchemaParser(io.vertx.json.schema.SchemaParser delegate) {
    this.delegate = delegate;
  }

  public SchemaParser(Object delegate) {
    this.delegate = (io.vertx.json.schema.SchemaParser)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SchemaParser() {
    this.delegate = null;
  }

  public io.vertx.json.schema.SchemaParser getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SchemaParser that = (SchemaParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param jsonSchema JSON representing the schema
   * @return the schema instance
   */
  public io.vertx.mutiny.json.schema.Schema parse(JsonObject jsonSchema) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema));
    return ret;
  }

  /**
   * @param jsonSchema JSON representing the schema
   * @param schemaPointer Scope of schema. Must be a JSONPointer with absolute URI
   * @return the schema instance
   */
  public io.vertx.mutiny.json.schema.Schema parse(JsonObject jsonSchema, io.vertx.mutiny.core.json.pointer.JsonPointer schemaPointer) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema, schemaPointer.getDelegate()));
    return ret;
  }

  /**
   * @param jsonSchema JSON representing the schema
   * @return the schema instance
   */
  public io.vertx.mutiny.json.schema.Schema parse(Boolean jsonSchema) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema));
    return ret;
  }

  /**
   * @param jsonSchema JSON representing the schema
   * @param schemaPointer Scope of schema. Must be a JSONPointer with absolute URI
   * @return the schema instance
   */
  public io.vertx.mutiny.json.schema.Schema parse(Boolean jsonSchema, io.vertx.mutiny.core.json.pointer.JsonPointer schemaPointer) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema, schemaPointer.getDelegate()));
    return ret;
  }

  /**
   * @param unparsedJson Unparsed JSON representing the schema.
   * @return the schema instance
   */
  public io.vertx.mutiny.json.schema.Schema parseFromString(String unparsedJson) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parseFromString(unparsedJson));
    return ret;
  }

  /**
   * @param unparsedJson Unparsed JSON representing the schema.
   * @param schemaPointer Scope of schema. Must be a JSONPointer with absolute URI
   * @return the schema instance
   */
  public io.vertx.mutiny.json.schema.Schema parseFromString(String unparsedJson, io.vertx.mutiny.core.json.pointer.JsonPointer schemaPointer) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parseFromString(unparsedJson, schemaPointer.getDelegate()));
    return ret;
  }

  /**
   * @return 
   */
  public io.vertx.mutiny.json.schema.SchemaRouter getSchemaRouter() { 
    io.vertx.mutiny.json.schema.SchemaRouter ret = io.vertx.mutiny.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)delegate.getSchemaRouter());
    return ret;
  }

  /**
   * @param router 
   * @return 
   */
  public static io.vertx.mutiny.json.schema.SchemaParser createOpenAPI3SchemaParser(io.vertx.mutiny.json.schema.SchemaRouter router) { 
    io.vertx.mutiny.json.schema.SchemaParser ret = io.vertx.mutiny.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)io.vertx.json.schema.SchemaParser.createOpenAPI3SchemaParser(router.getDelegate()));
    return ret;
  }

  /**
   * @param router 
   * @return 
   */
  public static io.vertx.mutiny.json.schema.SchemaParser createDraft7SchemaParser(io.vertx.mutiny.json.schema.SchemaRouter router) { 
    io.vertx.mutiny.json.schema.SchemaParser ret = io.vertx.mutiny.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)io.vertx.json.schema.SchemaParser.createDraft7SchemaParser(router.getDelegate()));
    return ret;
  }

  /**
   * @param router 
   * @return 
   */
  public static io.vertx.mutiny.json.schema.SchemaParser createDraft201909SchemaParser(io.vertx.mutiny.json.schema.SchemaRouter router) { 
    io.vertx.mutiny.json.schema.SchemaParser ret = io.vertx.mutiny.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)io.vertx.json.schema.SchemaParser.createDraft201909SchemaParser(router.getDelegate()));
    return ret;
  }

  /**
   * @param factory new factory
   * @return a reference to this
   */
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaParser withValidatorFactory(io.vertx.json.schema.common.ValidatorFactory factory) { 
    delegate.withValidatorFactory(factory);
    return this;
  }

  /**
   * @param formatName format name
   * @param predicate predicate for the new format
   * @return a reference to this
   */
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaParser withStringFormatValidator(String formatName, java.util.function.Predicate<String> predicate) { 
    delegate.withStringFormatValidator(formatName, predicate);
    return this;
  }

  public static  SchemaParser newInstance(io.vertx.json.schema.SchemaParser arg) {
    return arg != null ? new SchemaParser(arg) : null;
  }

}
