package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Predicate;
import java.util.Map.Entry;
import java.util.Set;
import io.vertx.core.json.JsonObject;

/**
 * A Json-Schema holder.
 * <p>
 * There are 2 kinds of Json-Schema's:
 *
 * <ul>
 *   <li>JSON Object based</li>
 *   <li>Boolean based</li>
 * </ul>
 * <p>
 * This is a common interface to handle all kinds of schemas.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.JsonSchema original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.JsonSchema.class)
public class JsonSchema {

  public static final io.smallrye.mutiny.vertx.TypeArg<JsonSchema> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JsonSchema((io.vertx.json.schema.JsonSchema) obj),
    JsonSchema::getDelegate
  );

  private final io.vertx.json.schema.JsonSchema delegate;
  
  public JsonSchema(io.vertx.json.schema.JsonSchema delegate) {
    this.delegate = delegate;
  }

  public JsonSchema(Object delegate) {
    this.delegate = (io.vertx.json.schema.JsonSchema)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JsonSchema() {
    this.delegate = null;
  }

  public io.vertx.json.schema.JsonSchema getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonSchema that = (JsonSchema) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param json a JSON Object.
   * @return a wrapper for the input object.
   */
  public static io.vertx.mutiny.json.schema.JsonSchema of(JsonObject json) { 
    io.vertx.mutiny.json.schema.JsonSchema ret = io.vertx.mutiny.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)io.vertx.json.schema.JsonSchema.of(json));
    return ret;
  }

  /**
   * @param id will force the given id as the schema $id.
   * @param json a JSON Object.
   * @return a wrapper for the input object.
   */
  public static io.vertx.mutiny.json.schema.JsonSchema of(String id, JsonObject json) { 
    io.vertx.mutiny.json.schema.JsonSchema ret = io.vertx.mutiny.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)io.vertx.json.schema.JsonSchema.of(id, json));
    return ret;
  }

  /**
   * @param bool a boolean.
   * @return a wrapper for the input object.
   */
  public static io.vertx.mutiny.json.schema.JsonSchema of(boolean bool) { 
    io.vertx.mutiny.json.schema.JsonSchema ret = io.vertx.mutiny.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)io.vertx.json.schema.JsonSchema.of(bool));
    return ret;
  }

  /**
   * @param key a key
   * @param value a value
   * @return the instance of JsonSchema to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.json.schema.JsonSchema annotate(String key, String value) { 
    delegate.annotate(key, value);
    return this;
  }

  /**
   * @param key a key
   * @return the value or <code>null</code>
   */
  public <R> R get(String key) { 
    R ret = (R) delegate.get(key);
    return ret;
  }

  /**
   * @param key a key
   * @param fallback fallback when key is not present
   * @return the value or <code>null</code>
   */
  public <R> R get(String key, R fallback) { 
    R ret = (R) delegate.get(key, fallback);
    return ret;
  }

  /**
   * @param key a key
   * @return <code>true</code> if present
   */
  public boolean containsKey(String key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * @return field names
   */
  public Set<String> fieldNames() { 
    Set<String> ret = delegate.fieldNames();
    return ret;
  }

  /**
   * @return a new  representing the schema with <code>$ref</code>s replaced by their value.
   */
  public JsonObject resolve() { 
    JsonObject ret = delegate.resolve();
    return ret;
  }

  /**
   * Predicate to filter out annotation keys.
   */
  public static final Predicate<String> EXCLUDE_ANNOTATIONS = io.vertx.json.schema.JsonSchema.EXCLUDE_ANNOTATIONS;
  /**
   * Predicate to filter out annotation keys.
   */
  public static final Predicate<Entry<String, Object>> EXCLUDE_ANNOTATION_ENTRIES = io.vertx.json.schema.JsonSchema.EXCLUDE_ANNOTATION_ENTRIES;
  public static  JsonSchema newInstance(io.vertx.json.schema.JsonSchema arg) {
    return arg != null ? new JsonSchema(arg) : null;
  }

}
