package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;

/**
 * JsonObject <code>$ref</code> resolver. This interface is used to resolve <code>$ref</code> in a . The result
 * is a new  with all the <code>$ref</code> replaced by actual object references.
 *
 * This new object allows navigation and queries using {@link io.vertx.mutiny.core.json.pointer.JsonPointer} but will not be
 * able to be encoded back to JSON when circular dependencies are present.
 *
 * The resolver will only resolve local references as defined in RFC3986. A local reference is a reference that starts
 * with <code>#</code> and is followed by a valid JSON Pointer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.Ref original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.Ref.class)
public class Ref {

  public static final io.smallrye.mutiny.vertx.TypeArg<Ref> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Ref((io.vertx.json.schema.Ref) obj),
    Ref::getDelegate
  );

  private final io.vertx.json.schema.Ref delegate;
  
  public Ref(io.vertx.json.schema.Ref delegate) {
    this.delegate = delegate;
  }

  public Ref(Object delegate) {
    this.delegate = (io.vertx.json.schema.Ref)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Ref() {
    this.delegate = null;
  }

  public io.vertx.json.schema.Ref getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Ref that = (Ref) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param json the JSON object to resolve.
   * @return a new JSON object with all the <code>$ref</code> replaced by actual object references.
   */
  public static JsonObject resolve(JsonObject json) { 
    JsonObject ret = io.vertx.json.schema.Ref.resolve(json);
    return ret;
  }

  public static  Ref newInstance(io.vertx.json.schema.Ref arg) {
    return arg != null ? new Ref(arg) : null;
  }

}
