package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.Draft;
import io.vertx.core.json.JsonObject;

/**
 * A repository is a holder of dereferenced schemas, it can be used to create validator instances for a specific schema.
 * <p>
 * This is to be used when multiple schema objects compose the global schema to be used for validation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.SchemaRepository original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.SchemaRepository.class)
public class SchemaRepository {

  public static final io.smallrye.mutiny.vertx.TypeArg<SchemaRepository> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SchemaRepository((io.vertx.json.schema.SchemaRepository) obj),
    SchemaRepository::getDelegate
  );

  private final io.vertx.json.schema.SchemaRepository delegate;
  
  public SchemaRepository(io.vertx.json.schema.SchemaRepository delegate) {
    this.delegate = delegate;
  }

  public SchemaRepository(Object delegate) {
    this.delegate = (io.vertx.json.schema.SchemaRepository)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SchemaRepository() {
    this.delegate = null;
  }

  public io.vertx.json.schema.SchemaRepository getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SchemaRepository that = (SchemaRepository) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param options the initial configuration
   * @return a repository
   */
  public static io.vertx.mutiny.json.schema.SchemaRepository create(io.vertx.json.schema.JsonSchemaOptions options) { 
    io.vertx.mutiny.json.schema.SchemaRepository ret = io.vertx.mutiny.json.schema.SchemaRepository.newInstance((io.vertx.json.schema.SchemaRepository)io.vertx.json.schema.SchemaRepository.create(options));
    return ret;
  }

  /**
   * @param schema a new schema to list
   * @return a repository
   */
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRepository dereference(io.vertx.mutiny.json.schema.JsonSchema schema) { 
    delegate.dereference(schema.getDelegate());
    return this;
  }

  /**
   * @param uri the source of the schema used for de-referencing, optionally relative to {@link io.vertx.json.schema.JsonSchemaOptions}.
   * @param schema a new schema to list
   * @return a repository
   */
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRepository dereference(String uri, io.vertx.mutiny.json.schema.JsonSchema schema) { 
    delegate.dereference(uri, schema.getDelegate());
    return this;
  }

  /**
   * @param fs The Vert.x file system to load the related schema meta files from classpath
   * @return a repository
   */
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRepository preloadMetaSchema(io.vertx.mutiny.core.file.FileSystem fs) { 
    delegate.preloadMetaSchema(fs.getDelegate());
    return this;
  }

  /**
   * @param fs The Vert.x file system to load the related schema meta files from classpath
   * @param draft The draft version of the meta files to load
   * @return a repository
   */
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRepository preloadMetaSchema(io.vertx.mutiny.core.file.FileSystem fs, io.vertx.json.schema.Draft draft) { 
    delegate.preloadMetaSchema(fs.getDelegate(), draft);
    return this;
  }

  /**
   * @param schema the start validation schema
   * @return the validator
   */
  public io.vertx.mutiny.json.schema.Validator validator(io.vertx.mutiny.json.schema.JsonSchema schema) { 
    io.vertx.mutiny.json.schema.Validator ret = io.vertx.mutiny.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)delegate.validator(schema.getDelegate()));
    return ret;
  }

  /**
   * @param ref the start validation reference in JSON pointer format
   * @return the validator
   */
  public io.vertx.mutiny.json.schema.Validator validator(String ref) { 
    io.vertx.mutiny.json.schema.Validator ret = io.vertx.mutiny.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)delegate.validator(ref));
    return ret;
  }

  /**
   * @param ref the start validation reference in JSON pointer format
   * @param options the options to be using on the validator instance
   * @return the validator
   */
  public io.vertx.mutiny.json.schema.Validator validator(String ref, io.vertx.json.schema.JsonSchemaOptions options) { 
    io.vertx.mutiny.json.schema.Validator ret = io.vertx.mutiny.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)delegate.validator(ref, options));
    return ret;
  }

  /**
   * @param schema the start validation schema
   * @param options the options to be using on the validator instance
   * @return the validator
   */
  public io.vertx.mutiny.json.schema.Validator validator(io.vertx.mutiny.json.schema.JsonSchema schema, io.vertx.json.schema.JsonSchemaOptions options) { 
    io.vertx.mutiny.json.schema.Validator ret = io.vertx.mutiny.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)delegate.validator(schema.getDelegate(), options));
    return ret;
  }

  /**
   * @param schema the start validation schema
   * @param options the options to be using on the validator instance
   * @param dereference if true the schema will be dereferenced before validation
   * @return the validator
   */
  public io.vertx.mutiny.json.schema.Validator validator(io.vertx.mutiny.json.schema.JsonSchema schema, io.vertx.json.schema.JsonSchemaOptions options, boolean dereference) { 
    io.vertx.mutiny.json.schema.Validator ret = io.vertx.mutiny.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)delegate.validator(schema.getDelegate(), options, dereference));
    return ret;
  }

  /**
   * @param schema the JSON object to resolve.
   * @return a new JSON object with all the <code>$ref</code> replaced by actual object references.
   */
  public JsonObject resolve(JsonObject schema) { 
    JsonObject ret = delegate.resolve(schema);
    return ret;
  }

  /**
   * @param ref the start resolution reference in JSON pointer format
   * @return a new  representing the schema with <code>$ref</code>s replaced by their value.
   */
  public JsonObject resolve(String ref) { 
    JsonObject ret = delegate.resolve(ref);
    return ret;
  }

  /**
   * @param schema 
   * @return a new  representing the schema with <code>$ref</code>s replaced by their value.
   */
  public JsonObject resolve(io.vertx.mutiny.json.schema.JsonSchema schema) { 
    JsonObject ret = delegate.resolve(schema.getDelegate());
    return ret;
  }

  /**
   * @param pointer the JSON pointer
   * @return the schema
   */
  public io.vertx.mutiny.json.schema.JsonSchema find(String pointer) { 
    io.vertx.mutiny.json.schema.JsonSchema ret = io.vertx.mutiny.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)delegate.find(pointer));
    return ret;
  }

  public static  SchemaRepository newInstance(io.vertx.json.schema.SchemaRepository arg) {
    return arg != null ? new SchemaRepository(arg) : null;
  }

}
