package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import java.util.List;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import java.net.URI;
import io.vertx.core.Handler;
import io.vertx.json.schema.SchemaRouterOptions;

/**
 * Represents a pool where parsed schemas are addressed and cached. <br/>
 * <p>
 * It also contains a cache of  including on top or inner level some json schemas that could eventually parsed later.<br/>
 * <p>
 * You should not share this object between different threads
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.SchemaRouter original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.SchemaRouter.class)
public class SchemaRouter {

  public static final io.smallrye.mutiny.vertx.TypeArg<SchemaRouter> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SchemaRouter((io.vertx.json.schema.SchemaRouter) obj),
    SchemaRouter::getDelegate
  );

  private final io.vertx.json.schema.SchemaRouter delegate;
  
  public SchemaRouter(io.vertx.json.schema.SchemaRouter delegate) {
    this.delegate = delegate;
  }

  public SchemaRouter(Object delegate) {
    this.delegate = (io.vertx.json.schema.SchemaRouter)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SchemaRouter() {
    this.delegate = null;
  }

  public io.vertx.json.schema.SchemaRouter getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.json.schema.Schema> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.json.schema.Schema>(o1 -> io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SchemaRouter that = (SchemaRouter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param refPointer 
   * @param schemaScope 
   * @param parser 
   * @return the resolved schema, or null if no schema was found
   * @deprecated   */
  @Deprecated
  public io.vertx.mutiny.json.schema.Schema resolveCachedSchema(io.vertx.mutiny.core.json.pointer.JsonPointer refPointer, io.vertx.mutiny.core.json.pointer.JsonPointer schemaScope, io.vertx.mutiny.json.schema.SchemaParser parser) { 
    io.vertx.mutiny.json.schema.Schema ret = io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.resolveCachedSchema(refPointer.getDelegate(), schemaScope.getDelegate(), parser.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.json.schema.SchemaRouter#resolveRef} but with a direct callback.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param pointer 
   * @param scope 
   * @param schemaParser 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.json.schema.Schema> resolveRef(io.vertx.mutiny.core.json.pointer.JsonPointer pointer, io.vertx.mutiny.core.json.pointer.JsonPointer scope, io.vertx.mutiny.json.schema.SchemaParser schemaParser) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resolveRef(pointer.getDelegate(), scope.getDelegate(), schemaParser.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.json.schema.SchemaRouter#resolveRef(io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.json.schema.SchemaParser)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param pointer 
   * @param scope 
   * @param schemaParser 
   * @return the Schema instance produced by the operation.
   * @deprecated   */
  @Deprecated
  public io.vertx.mutiny.json.schema.Schema resolveRefAndAwait(io.vertx.mutiny.core.json.pointer.JsonPointer pointer, io.vertx.mutiny.core.json.pointer.JsonPointer scope, io.vertx.mutiny.json.schema.SchemaParser schemaParser) { 
    return (io.vertx.mutiny.json.schema.Schema) resolveRef(pointer, scope, schemaParser).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.json.schema.SchemaRouter#resolveRef(io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.json.schema.SchemaParser)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.json.schema.SchemaRouter#resolveRef(io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.json.schema.SchemaParser)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.json.schema.SchemaRouter#resolveRef(io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.core.json.pointer.JsonPointer,io.vertx.mutiny.json.schema.SchemaParser)} but you don't need to compose it with other operations.
   * @param pointer 
   * @param scope 
   * @param schemaParser 
   * @deprecated   */
  @Deprecated
  public void resolveRefAndForget(io.vertx.mutiny.core.json.pointer.JsonPointer pointer, io.vertx.mutiny.core.json.pointer.JsonPointer scope, io.vertx.mutiny.json.schema.SchemaParser schemaParser) { 
    resolveRef(pointer, scope, schemaParser).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param schema schema to add
   * @param scope 
   * @return a reference to this
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRouter addSchemaWithScope(io.vertx.mutiny.json.schema.Schema schema, io.vertx.mutiny.core.json.pointer.JsonPointer scope) { 
    delegate.addSchemaWithScope(schema.getDelegate(), scope.getDelegate());
    return this;
  }

  /**
   * @param schema schema to add
   * @param alias the schema alias
   * @return a reference to this
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRouter addSchemaAlias(io.vertx.mutiny.json.schema.Schema schema, String alias) { 
    delegate.addSchemaAlias(schema.getDelegate(), alias);
    return this;
  }

  /**
   * @param uri 
   * @param object 
   * @return a reference to this
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRouter addJson(String uri, JsonObject object) { 
    delegate.addJson(uri, object);
    return this;
  }

  /**
   * @return a list of all registered schemas
   * @deprecated   */
  @Deprecated
  public List<io.vertx.mutiny.json.schema.Schema> registeredSchemas() { 
    List<io.vertx.mutiny.json.schema.Schema> ret = delegate.registeredSchemas().stream().map(elt -> io.vertx.mutiny.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @param vertx 
   * @param schemaRouterOptions 
   * @return 
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.json.schema.SchemaRouter create(io.vertx.mutiny.core.Vertx vertx, io.vertx.json.schema.SchemaRouterOptions schemaRouterOptions) { 
    io.vertx.mutiny.json.schema.SchemaRouter ret = io.vertx.mutiny.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)io.vertx.json.schema.SchemaRouter.create(vertx.getDelegate(), schemaRouterOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param client 
   * @param fs 
   * @param schemaRouterOptions 
   * @return 
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.json.schema.SchemaRouter create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.core.http.HttpClient client, io.vertx.mutiny.core.file.FileSystem fs, io.vertx.json.schema.SchemaRouterOptions schemaRouterOptions) { 
    io.vertx.mutiny.json.schema.SchemaRouter ret = io.vertx.mutiny.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)io.vertx.json.schema.SchemaRouter.create(vertx.getDelegate(), client.getDelegate(), fs.getDelegate(), schemaRouterOptions));
    return ret;
  }

  /**
   * @param schema schema to add
   * @param aliasScopes 
   * @return a reference to this
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRouter addSchema(io.vertx.mutiny.json.schema.Schema schema, io.vertx.core.json.pointer.JsonPointer[] aliasScopes) { 
    delegate.addSchema(schema.getDelegate(), aliasScopes);
    return this;
  }

  /**
   * @param uri 
   * @param object 
   * @return a reference to this
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.json.schema.SchemaRouter addJson(java.net.URI uri, JsonObject object) { 
    delegate.addJson(uri, object);
    return this;
  }

  public static  SchemaRouter newInstance(io.vertx.json.schema.SchemaRouter arg) {
    return arg != null ? new SchemaRouter(arg) : null;
  }

}
