package io.vertx.mutiny.json.schema;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputUnit;

/**
 * A validator, validates some input object using a well known schema.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.Validator original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.json.schema.Validator.class)
public class Validator {

  public static final io.smallrye.mutiny.vertx.TypeArg<Validator> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Validator((io.vertx.json.schema.Validator) obj),
    Validator::getDelegate
  );

  private final io.vertx.json.schema.Validator delegate;
  
  public Validator(io.vertx.json.schema.Validator delegate) {
    this.delegate = delegate;
  }

  public Validator(Object delegate) {
    this.delegate = (io.vertx.json.schema.Validator)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Validator() {
    this.delegate = null;
  }

  public io.vertx.json.schema.Validator getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Validator that = (Validator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param schema the initial schema
   * @param options the validator options
   * @return a validator instance
   */
  public static io.vertx.mutiny.json.schema.Validator create(io.vertx.mutiny.json.schema.JsonSchema schema, io.vertx.json.schema.JsonSchemaOptions options) { 
    io.vertx.mutiny.json.schema.Validator ret = io.vertx.mutiny.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)io.vertx.json.schema.Validator.create(schema.getDelegate(), options));
    return ret;
  }

  /**
   * @param instance instance to validate
   * @return returns a output unit object as defined by the options
   */
  public io.vertx.json.schema.OutputUnit validate(java.lang.Object instance) { 
    io.vertx.json.schema.OutputUnit ret = delegate.validate(instance);
    return ret;
  }

  public static  Validator newInstance(io.vertx.json.schema.Validator arg) {
    return arg != null ? new Validator(arg) : null;
  }

}
