package io.vertx.mutiny.kafka.admin;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.NewPartitions;
import java.util.Set;
import io.vertx.core.Future;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.List;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.TopicDescription;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka Admin client implementation
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.KafkaAdminClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaAdminClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient) obj),
    KafkaAdminClient::getDelegate
  );

  private final io.vertx.kafka.admin.KafkaAdminClient delegate;
  
  public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
    this.delegate = delegate;
  }

  public KafkaAdminClient(Object delegate) {
    this.delegate = (io.vertx.kafka.admin.KafkaAdminClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  KafkaAdminClient() {
    this.delegate = null;
  }

  public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaAdminClient that = (KafkaAdminClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka admin client configuration
   * @return an instance of the KafkaAdminClient
   */
  public static io.vertx.mutiny.kafka.admin.KafkaAdminClient create(io.vertx.mutiny.core.Vertx vertx, java.util.Map<String, String> config) { 
    io.vertx.mutiny.kafka.admin.KafkaAdminClient ret = io.vertx.mutiny.kafka.admin.KafkaAdminClient.newInstance((io.vertx.kafka.admin.KafkaAdminClient)io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * List the topics available in the cluster with the default options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Set<String>> listTopics() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.listTopics(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listTopics}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<String> instance produced by the operation.
   */
  public Set<String> listTopicsAndAwait() { 
    return (Set<String>) listTopics().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listTopics} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listTopics}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listTopics} but you don't need to compose it with other operations.
   */
  public void listTopicsAndForget() { 
    listTopics().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Describe some topics in the cluster, with the default options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicNames the names of the topics to describe
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<java.util.Map<String, io.vertx.kafka.admin.TopicDescription>> describeTopics(List<String> topicNames) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.describeTopics(topicNames, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeTopics(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicNames the names of the topics to describe
   * @return the Map<String,TopicDescription> instance produced by the operation.
   */
  public java.util.Map<String, io.vertx.kafka.admin.TopicDescription> describeTopicsAndAwait(List<String> topicNames) { 
    return (java.util.Map<String, io.vertx.kafka.admin.TopicDescription>) describeTopics(topicNames).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeTopics(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeTopics(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeTopics(List)} but you don't need to compose it with other operations.
   * @param topicNames the names of the topics to describe
   */
  public void describeTopicsAndForget(List<String> topicNames) { 
    describeTopics(topicNames).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Creates a batch of new Kafka topics
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topics topics to create
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createTopics(List<io.vertx.kafka.admin.NewTopic> topics) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createTopics(topics, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createTopics(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topics topics to create
   * @return the Void instance produced by the operation.
   */
  public Void createTopicsAndAwait(List<io.vertx.kafka.admin.NewTopic> topics) { 
    return (Void) createTopics(topics).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createTopics(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createTopics(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createTopics(List)} but you don't need to compose it with other operations.
   * @param topics topics to create
   */
  public void createTopicsAndForget(List<io.vertx.kafka.admin.NewTopic> topics) { 
    createTopics(topics).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Deletes a batch of Kafka topics
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicNames the names of the topics to delete
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deleteTopics(List<String> topicNames) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.deleteTopics(topicNames, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteTopics(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicNames the names of the topics to delete
   * @return the Void instance produced by the operation.
   */
  public Void deleteTopicsAndAwait(List<String> topicNames) { 
    return (Void) deleteTopics(topicNames).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteTopics(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteTopics(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteTopics(List)} but you don't need to compose it with other operations.
   * @param topicNames the names of the topics to delete
   */
  public void deleteTopicsAndForget(List<String> topicNames) { 
    deleteTopics(topicNames).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Creates a batch of new partitions in the Kafka topic
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param partitions partitions to create
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> createPartitions(java.util.Map<String, io.vertx.kafka.admin.NewPartitions> partitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createPartitions(partitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createPartitions(Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param partitions partitions to create
   * @return the Void instance produced by the operation.
   */
  public Void createPartitionsAndAwait(java.util.Map<String, io.vertx.kafka.admin.NewPartitions> partitions) { 
    return (Void) createPartitions(partitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createPartitions(Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createPartitions(Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createPartitions(Map)} but you don't need to compose it with other operations.
   * @param partitions partitions to create
   */
  public void createPartitionsAndForget(java.util.Map<String, io.vertx.kafka.admin.NewPartitions> partitions) { 
    createPartitions(partitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.kafka.admin.ConsumerGroupListing>> listConsumerGroups() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.listConsumerGroups(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listConsumerGroups}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<ConsumerGroupListing> instance produced by the operation.
   */
  public List<io.vertx.kafka.admin.ConsumerGroupListing> listConsumerGroupsAndAwait() { 
    return (List<io.vertx.kafka.admin.ConsumerGroupListing>) listConsumerGroups().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listConsumerGroups} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listConsumerGroups}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listConsumerGroups} but you don't need to compose it with other operations.
   */
  public void listConsumerGroupsAndForget() { 
    listConsumerGroups().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Describe some group ids in the cluster, with the default options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param groupIds the ids of the groups to describe
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<java.util.Map<String, io.vertx.kafka.admin.ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.describeConsumerGroups(groupIds, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeConsumerGroups(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param groupIds the ids of the groups to describe
   * @return the Map<String,ConsumerGroupDescription> instance produced by the operation.
   */
  public java.util.Map<String, io.vertx.kafka.admin.ConsumerGroupDescription> describeConsumerGroupsAndAwait(List<String> groupIds) { 
    return (java.util.Map<String, io.vertx.kafka.admin.ConsumerGroupDescription>) describeConsumerGroups(groupIds).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeConsumerGroups(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeConsumerGroups(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeConsumerGroups(List)} but you don't need to compose it with other operations.
   * @param groupIds the ids of the groups to describe
   */
  public void describeConsumerGroupsAndForget(List<String> groupIds) { 
    describeConsumerGroups(groupIds).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Describe the nodes in the cluster with the default options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.kafka.admin.ClusterDescription> describeCluster() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.describeCluster(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeCluster}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ClusterDescription instance produced by the operation.
   */
  public io.vertx.kafka.admin.ClusterDescription describeClusterAndAwait() { 
    return (io.vertx.kafka.admin.ClusterDescription) describeCluster().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeCluster} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeCluster}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeCluster} but you don't need to compose it with other operations.
   */
  public void describeClusterAndForget() { 
    describeCluster().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Delete consumer groups from the cluster.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param groupIds the ids of the groups to delete
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deleteConsumerGroups(List<String> groupIds) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.deleteConsumerGroups(groupIds, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroups(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param groupIds the ids of the groups to delete
   * @return the Void instance produced by the operation.
   */
  public Void deleteConsumerGroupsAndAwait(List<String> groupIds) { 
    return (Void) deleteConsumerGroups(groupIds).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroups(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroups(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroups(List)} but you don't need to compose it with other operations.
   * @param groupIds the ids of the groups to delete
   */
  public void deleteConsumerGroupsAndForget(List<String> groupIds) { 
    deleteConsumerGroups(groupIds).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Delete committed offsets for a set of partitions in a consumer group. This will
   * succeed at the partition level only if the group is not actively subscribed
   * to the corresponding topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param groupId The group id of the group whose offsets will be deleted
   * @param partitions The set of partitions in the consumer group whose offsets will be deleted
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deleteConsumerGroupOffsets(String groupId, Set<io.vertx.kafka.client.common.TopicPartition> partitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.deleteConsumerGroupOffsets(groupId, partitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroupOffsets(String,Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param groupId The group id of the group whose offsets will be deleted
   * @param partitions The set of partitions in the consumer group whose offsets will be deleted
   * @return the Void instance produced by the operation.
   */
  public Void deleteConsumerGroupOffsetsAndAwait(String groupId, Set<io.vertx.kafka.client.common.TopicPartition> partitions) { 
    return (Void) deleteConsumerGroupOffsets(groupId, partitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroupOffsets(String,Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroupOffsets(String,Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroupOffsets(String,Set)} but you don't need to compose it with other operations.
   * @param groupId The group id of the group whose offsets will be deleted
   * @param partitions The set of partitions in the consumer group whose offsets will be deleted
   */
  public void deleteConsumerGroupOffsetsAndForget(String groupId, Set<io.vertx.kafka.client.common.TopicPartition> partitions) { 
    deleteConsumerGroupOffsets(groupId, partitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the admin client
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the admin client
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout timeout to wait for closing
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout timeout to wait for closing
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait(long timeout) { 
    return (Void) close(timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close(long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close(long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close(long)} but you don't need to compose it with other operations.
   * @param timeout timeout to wait for closing
   */
  public void closeAndForget(long timeout) { 
    close(timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
    return arg != null ? new KafkaAdminClient(arg) : null;
  }

}
