package io.vertx.mutiny.kafka.client.producer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.producer.RecordMetadata;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.core.Future;
import java.util.List;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka producer.
 * <p>
 * The {@link io.vertx.mutiny.core.streams.WriteStream#write} provides global control over writing a record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaProducer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public KafkaProducer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  KafkaProducer() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducer that = (KafkaProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>> subscriber;

  @CheckReturnValue
  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(arg1 -> {
        delegate.write(arg0.getDelegate(), arg1);
    });
  }

  public Void writeAndAwait(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> arg0) { 
    return (Void) write(arg0).await().indefinitely();
  }

  public void writeAndForget(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> arg0) { 
    write(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(arg0 -> {
        delegate.end(arg0);
    });
  }

  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(data.getDelegate(), handler);
    });
  }

  public Void endAndAwait(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return (Void) end(data).await().indefinitely();
  }

  public void endAndForget(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    end(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.mutiny.core.Vertx vertx, String name, java.util.Map<String, String> config) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.mutiny.core.Vertx vertx, String name, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.mutiny.core.Vertx vertx, String name, java.util.Map<String, String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.mutiny.core.Vertx vertx, String name, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> create(io.vertx.mutiny.core.Vertx vertx, java.util.Map<String, String> config) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> create(io.vertx.mutiny.core.Vertx vertx, java.util.Map<String, String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> initTransactions() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.initTransactions(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#initTransactions}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void initTransactionsAndAwait() { 
    return (Void) initTransactions().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#initTransactions} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#initTransactions}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#initTransactions} but you don't need to compose it with other operations.
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> initTransactionsAndForget() { 
    initTransactions().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#beginTransaction}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> beginTransaction() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.beginTransaction(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#beginTransaction}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void beginTransactionAndAwait() { 
    return (Void) beginTransaction().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#beginTransaction} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#beginTransaction}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#beginTransaction} but you don't need to compose it with other operations.
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> beginTransactionAndForget() { 
    beginTransaction().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#commitTransaction}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> commitTransaction() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.commitTransaction(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#commitTransaction}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void commitTransactionAndAwait() { 
    return (Void) commitTransaction().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#commitTransaction} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#commitTransaction}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#commitTransaction} but you don't need to compose it with other operations.
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> commitTransactionAndForget() { 
    commitTransaction().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> abortTransaction() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.abortTransaction(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#abortTransaction}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void abortTransactionAndAwait() { 
    return (Void) abortTransaction().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#abortTransaction} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#abortTransaction}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#abortTransaction} but you don't need to compose it with other operations.
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> abortTransactionAndForget() { 
    abortTransaction().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> drainHandler(java.lang.Runnable handler) {
    return __drainHandler(ignored -> handler.run()
);
  }

  /**
   * Asynchronously write a record to a topic
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param record record to write
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.kafka.client.producer.RecordMetadata> send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(record.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param record record to write
   * @return the RecordMetadata instance produced by the operation.
   */
  public io.vertx.kafka.client.producer.RecordMetadata sendAndAwait(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    return (io.vertx.kafka.client.producer.RecordMetadata) send(record).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord)} but you don't need to compose it with other operations.
   * @param record record to write
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> sendAndForget(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    send(record).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the partition metadata for the give topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic partition for which getting partitions info
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.kafka.client.common.PartitionInfo>> partitionsFor(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.partitionsFor(topic, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#partitionsFor(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic partition for which getting partitions info
   * @return the List<PartitionInfo> instance produced by the operation.
   */
  public List<io.vertx.kafka.client.common.PartitionInfo> partitionsForAndAwait(String topic) { 
    return (List<io.vertx.kafka.client.common.PartitionInfo>) partitionsFor(topic).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#partitionsFor(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#partitionsFor(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#partitionsFor(String)} but you don't need to compose it with other operations.
   * @param topic topic partition for which getting partitions info
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> partitionsForAndForget(String topic) { 
    partitionsFor(topic).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> flush() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.flush(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#flush}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void flushAndAwait() { 
    return (Void) flush().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#flush} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#flush}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#flush} but you don't need to compose it with other operations.
   * @return the instance of KafkaProducer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> flushAndForget() { 
    flush().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Close the producer
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the producer
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout timeout to wait for closing
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(timeout, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout timeout to wait for closing
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait(long timeout) { 
    return (Void) close(timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close(long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close(long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close(long)} but you don't need to compose it with other operations.
   * @param timeout timeout to wait for closing
   */
  public void closeAndForget(long timeout) { 
    close(timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static <K,V>KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K,V>(arg) : null;
  }


  public static <K,V>KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
