package io.vertx.mutiny.kafka.client.consumer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import org.apache.kafka.common.record.TimestampType;

/**
 * Vert.x Kafka consumer record
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumerRecord original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.client.consumer.KafkaConsumerRecord.class)
public class KafkaConsumerRecord<K,V> {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaConsumerRecord> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaConsumerRecord((io.vertx.kafka.client.consumer.KafkaConsumerRecord) obj),
    KafkaConsumerRecord::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public KafkaConsumerRecord(io.vertx.kafka.client.consumer.KafkaConsumerRecord delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public KafkaConsumerRecord(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.consumer.KafkaConsumerRecord)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public KafkaConsumerRecord(io.vertx.kafka.client.consumer.KafkaConsumerRecord delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  KafkaConsumerRecord() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.kafka.client.consumer.KafkaConsumerRecord getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.kafka.client.producer.KafkaHeader> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.kafka.client.producer.KafkaHeader>(o1 -> io.vertx.mutiny.kafka.client.producer.KafkaHeader.newInstance((io.vertx.kafka.client.producer.KafkaHeader)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumerRecord that = (KafkaConsumerRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the topic this record is received from
   */
  public String topic() { 
    String ret = delegate.topic();
    return ret;
  }

  /**
   * @return the partition from which this record is received
   */
  public int partition() { 
    int ret = delegate.partition();
    return ret;
  }

  /**
   * @return the position of this record in the corresponding Kafka partition.
   */
  public long offset() { 
    long ret = delegate.offset();
    return ret;
  }

  /**
   * @return the timestamp of this record
   */
  public long timestamp() { 
    long ret = delegate.timestamp();
    return ret;
  }

  /**
   * @return the timestamp type of this record
   */
  public org.apache.kafka.common.record.TimestampType timestampType() { 
    org.apache.kafka.common.record.TimestampType ret = delegate.timestampType();
    return ret;
  }

  /**
   * @return the key (or null if no key is specified)
   */
  public K key() { 
    K ret = (K)__typeArg_0.wrap(delegate.key());
    return ret;
  }

  /**
   * @return the value
   */
  public V value() { 
    V ret = (V)__typeArg_1.wrap(delegate.value());
    return ret;
  }

  /**
   * @return the list of consumer record headers
   */
  public List<io.vertx.mutiny.kafka.client.producer.KafkaHeader> headers() { 
    List<io.vertx.mutiny.kafka.client.producer.KafkaHeader> ret = delegate.headers().stream().map(elt -> io.vertx.mutiny.kafka.client.producer.KafkaHeader.newInstance((io.vertx.kafka.client.producer.KafkaHeader)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  public static <K,V>KafkaConsumerRecord<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumerRecord arg) {
    return arg != null ? new KafkaConsumerRecord<K,V>(arg) : null;
  }


  public static <K,V>KafkaConsumerRecord<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumerRecord arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumerRecord<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
