package io.vertx.mutiny.ext.mail;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.ext.mail.MailConfig;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;

/**
 * SMTP mail client for Vert.x
 * <p>
 * A simple asynchronous API for sending mails from Vert.x applications
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.mail.MailClient.class)
public class MailClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<MailClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MailClient((io.vertx.ext.mail.MailClient) obj),
    MailClient::getDelegate
  );

  private final io.vertx.ext.mail.MailClient delegate;
  
  public MailClient(io.vertx.ext.mail.MailClient delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MailClient() {    this.delegate = null;
  }

  public io.vertx.ext.mail.MailClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailClient that = (MailClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @param config 
   * @return 
   */
  @Deprecated
  public static io.vertx.mutiny.ext.mail.MailClient createNonShared(io.vertx.mutiny.core.Vertx vertx, MailConfig config) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance(io.vertx.ext.mail.MailClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx the Vertx instance the operation will be run in
   * @param config MailConfig configuration to be used for sending mails
   * @return MailClient instance that can then be used to send multiple mails
   */
  public static io.vertx.mutiny.ext.mail.MailClient create(io.vertx.mutiny.core.Vertx vertx, MailConfig config) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance(io.vertx.ext.mail.MailClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static io.vertx.mutiny.ext.mail.MailClient createShared(io.vertx.mutiny.core.Vertx vertx, MailConfig config, String poolName) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance(io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.mutiny.ext.mail.MailClient createShared(io.vertx.mutiny.core.Vertx vertx, MailConfig config) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance(io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @param resultHandler will be called when the operation is finished or it fails (may be null to ignore the result)
   * @return this MailClient instance so the method can be used fluently
   */
  private io.vertx.mutiny.ext.mail.MailClient __sendMail(MailMessage email, Handler<AsyncResult<MailResult>> resultHandler) { 
    delegate.sendMail(email, resultHandler);
    return this;
  }

  /**
   * send a single mail via MailClient
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return this MailClient instance so the method can be used fluently
   */
  public Uni<MailResult> sendMail(MailMessage email) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendMail(email, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mail.MailClient#sendMail(MailMessage)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return this MailClient instance so the method can be used fluently
   */
  public MailResult sendMailAndAwait(MailMessage email) { 
    return (MailResult) sendMail(email).await().indefinitely();
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mail.MailClient.DEFAULT_POOL_NAME;
  public static  MailClient newInstance(io.vertx.ext.mail.MailClient arg) {
    return arg != null ? new MailClient(arg) : null;
  }

}
