package io.vertx.mutiny.ext.mail;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;

/**
 * Represent a mail attachment that can be used in a MailMessage.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailAttachment original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.mail.MailAttachment.class)
public class MailAttachment {

  public static final io.smallrye.mutiny.vertx.TypeArg<MailAttachment> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MailAttachment((io.vertx.ext.mail.MailAttachment) obj),
    MailAttachment::getDelegate
  );

  private final io.vertx.ext.mail.MailAttachment delegate;
  
  public MailAttachment(io.vertx.ext.mail.MailAttachment delegate) {
    this.delegate = delegate;
  }

  public MailAttachment(Object delegate) {
    this.delegate = (io.vertx.ext.mail.MailAttachment)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MailAttachment() {
    this.delegate = null;
  }

  public io.vertx.ext.mail.MailAttachment getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailAttachment that = (MailAttachment) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public static io.vertx.mutiny.ext.mail.MailAttachment create() { 
    io.vertx.mutiny.ext.mail.MailAttachment ret = io.vertx.mutiny.ext.mail.MailAttachment.newInstance((io.vertx.ext.mail.MailAttachment)io.vertx.ext.mail.MailAttachment.create());
    return ret;
  }

  /**
   * @param json object to be copied
   * @return 
   */
  public static io.vertx.mutiny.ext.mail.MailAttachment create(JsonObject json) { 
    io.vertx.mutiny.ext.mail.MailAttachment ret = io.vertx.mutiny.ext.mail.MailAttachment.newInstance((io.vertx.ext.mail.MailAttachment)io.vertx.ext.mail.MailAttachment.create(json));
    return ret;
  }

  /**
   * @param other object to be copied
   * @return 
   */
  public static io.vertx.mutiny.ext.mail.MailAttachment create(io.vertx.mutiny.ext.mail.MailAttachment other) { 
    io.vertx.mutiny.ext.mail.MailAttachment ret = io.vertx.mutiny.ext.mail.MailAttachment.newInstance((io.vertx.ext.mail.MailAttachment)io.vertx.ext.mail.MailAttachment.create(other.getDelegate()));
    return ret;
  }

  /**
   * @return the data
   */
  public io.vertx.mutiny.core.buffer.Buffer getData() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getData());
    return ret;
  }

  /**
   * @param data Buffer of bytes to be used at attachment
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setData(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.setData(data.getDelegate());
    return this;
  }

  /**
   * @return the data stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> getStream() { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.getStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param stream data stream to be used at attachment
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setStream(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    delegate.setStream(stream.getDelegate());
    return this;
  }

  /**
   * @param stream data stream to be used at attachment
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setStream(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    delegate.setStream(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume());
    return this;
  }

  /**
   * @return the size of the attachment
   */
  public int getSize() { 
    int ret = delegate.getSize();
    return ret;
  }

  /**
   * @param size the size of the attachment
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setSize(int size) { 
    delegate.setSize(size);
    return this;
  }

  /**
   * @return the name
   */
  public String getName() { 
    String ret = delegate.getName();
    return ret;
  }

  /**
   * @param name name of the attachment file
   * @return this to be able to use it fluently <p> name is the descriptive filename that will be put into the mail i.e. usually a local filename without path this can be set to "" to omit the filename attribute
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setName(String name) { 
    delegate.setName(name);
    return this;
  }

  /**
   * @return the contentType
   */
  public String getContentType() { 
    String ret = delegate.getContentType();
    return ret;
  }

  /**
   * @param contentType the contentType
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setContentType(String contentType) { 
    delegate.setContentType(contentType);
    return this;
  }

  /**
   * @return the disposition
   */
  public String getDisposition() { 
    String ret = delegate.getDisposition();
    return ret;
  }

  /**
   * @param disposition the disposition
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setDisposition(String disposition) { 
    delegate.setDisposition(disposition);
    return this;
  }

  /**
   * @return the description
   */
  public String getDescription() { 
    String ret = delegate.getDescription();
    return ret;
  }

  /**
   * @param description the description
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setDescription(String description) { 
    delegate.setDescription(description);
    return this;
  }

  /**
   * @return the content id
   */
  public String getContentId() { 
    String ret = delegate.getContentId();
    return ret;
  }

  /**
   * @param contentId the content id
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setContentId(String contentId) { 
    delegate.setContentId(contentId);
    return this;
  }

  /**
   * @param key the header key
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment addHeader(String key, String value) { 
    delegate.addHeader(key, value);
    return this;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap getHeaders() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.getHeaders());
    return ret;
  }

  /**
   * @param headers the headers to be added
   * @return this to be able to use it fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailAttachment setHeaders(io.vertx.mutiny.core.MultiMap headers) { 
    delegate.setHeaders(headers.getDelegate());
    return this;
  }

  /**
   * @return the JSON object
   */
  public JsonObject toJson() { 
    JsonObject ret = delegate.toJson();
    return ret;
  }

  public static  MailAttachment newInstance(io.vertx.ext.mail.MailAttachment arg) {
    return arg != null ? new MailAttachment(arg) : null;
  }

}
