package io.vertx.mutiny.micrometer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A Vert.x Web {@link io.vertx.mutiny.ext.web.Route} handler for Prometheus metrics scraping.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.micrometer.PrometheusScrapingHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.micrometer.PrometheusScrapingHandler.class)
public class PrometheusScrapingHandler {

  public static final io.smallrye.mutiny.vertx.TypeArg<PrometheusScrapingHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PrometheusScrapingHandler((io.vertx.micrometer.PrometheusScrapingHandler) obj),
    PrometheusScrapingHandler::getDelegate
  );

  private final io.vertx.micrometer.PrometheusScrapingHandler delegate;
  
  public PrometheusScrapingHandler(io.vertx.micrometer.PrometheusScrapingHandler delegate) {
    this.delegate = delegate;
  }

  public PrometheusScrapingHandler(Object delegate) {
    this.delegate = (io.vertx.micrometer.PrometheusScrapingHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PrometheusScrapingHandler() {
    this.delegate = null;
  }

  public io.vertx.micrometer.PrometheusScrapingHandler getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.RoutingContext> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.ext.web.RoutingContext>(o1 -> io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.RoutingContext> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.web.RoutingContext>(o1 -> io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PrometheusScrapingHandler that = (PrometheusScrapingHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a {@link io.vertx.mutiny.ext.web.Route} handler for the default backend registry
   */
  public static Handler<io.vertx.mutiny.ext.web.RoutingContext> create() { 
    Handler<io.vertx.mutiny.ext.web.RoutingContext> ret = new Handler<io.vertx.mutiny.ext.web.RoutingContext>() {
      public void handle(io.vertx.mutiny.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * @param registryName the backend metrics registry
   * @return a {@link io.vertx.mutiny.ext.web.Route} handler for a specific metrics registry
   */
  public static Handler<io.vertx.mutiny.ext.web.RoutingContext> create(String registryName) { 
    Handler<io.vertx.mutiny.ext.web.RoutingContext> ret = new Handler<io.vertx.mutiny.ext.web.RoutingContext>() {
      public void handle(io.vertx.mutiny.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create(registryName).handle(event.getDelegate());
      }
    };
    return ret;
  }

  public static  PrometheusScrapingHandler newInstance(io.vertx.micrometer.PrometheusScrapingHandler arg) {
    return arg != null ? new PrometheusScrapingHandler(arg) : null;
  }

}
