package io.vertx.mutiny.micrometer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Set;
import io.vertx.core.json.JsonObject;

/**
 * The metrics service mainly allows to return a snapshot of measured objects.<br/>
 * This service is derived and adapted from <code>MetricsService</code> in the <i>vertx-dropwizard-metrics</i> module.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.micrometer.MetricsService original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.micrometer.MetricsService.class)
public class MetricsService {

  public static final io.smallrye.mutiny.vertx.TypeArg<MetricsService> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MetricsService((io.vertx.micrometer.MetricsService) obj),
    MetricsService::getDelegate
  );

  private final io.vertx.micrometer.MetricsService delegate;
  
  public MetricsService(io.vertx.micrometer.MetricsService delegate) {
    this.delegate = delegate;
  }

  public MetricsService(Object delegate) {
    this.delegate = (io.vertx.micrometer.MetricsService)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MetricsService() {
    this.delegate = null;
  }

  public io.vertx.micrometer.MetricsService getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MetricsService that = (MetricsService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param measured the measured object
   * @return the metrics service
   */
  public static io.vertx.mutiny.micrometer.MetricsService create(io.vertx.mutiny.core.metrics.Measured measured) { 
    io.vertx.mutiny.micrometer.MetricsService ret = io.vertx.mutiny.micrometer.MetricsService.newInstance((io.vertx.micrometer.MetricsService)io.vertx.micrometer.MetricsService.create(measured.getDelegate()));
    return ret;
  }

  /**
   * @return the base name of the measured object
   */
  public String getBaseName() { 
    String ret = delegate.getBaseName();
    return ret;
  }

  /**
   * @return the known metrics names by this service
   */
  public Set<String> metricsNames() { 
    Set<String> ret = delegate.metricsNames();
    return ret;
  }

  /**
   * @return the map of metrics where the key is the name of the metric (excluding the base name unless for the Vert.x object) and the value is the json data representing that metric
   */
  public JsonObject getMetricsSnapshot() { 
    JsonObject ret = delegate.getMetricsSnapshot();
    return ret;
  }

  /**
   * @param baseName 
   * @return the map of metrics where the key is the name of the metric and the value is the json data representing that metric
   */
  public JsonObject getMetricsSnapshot(String baseName) { 
    JsonObject ret = delegate.getMetricsSnapshot(baseName);
    return ret;
  }

  public static  MetricsService newInstance(io.vertx.micrometer.MetricsService arg) {
    return arg != null ? new MetricsService(arg) : null;
  }

}
