/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.mqtt.messages.MqttConnAckMessage;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import io.vertx.mutiny.mqtt.messages.MqttSubAckMessage;
import java.util.Map;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.mqtt.MqttClient.class)
public class MqttClient {
    public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg(obj -> new MqttClient((io.vertx.mqtt.MqttClient)obj), MqttClient::getDelegate);
    private final io.vertx.mqtt.MqttClient delegate;

    public MqttClient(io.vertx.mqtt.MqttClient delegate) {
        this.delegate = delegate;
    }

    MqttClient() {
        this.delegate = null;
    }

    public io.vertx.mqtt.MqttClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttClient that = (MqttClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static MqttClient create(io.vertx.mutiny.core.Vertx vertx, MqttClientOptions options) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate(), (MqttClientOptions)options));
        return ret;
    }

    public static MqttClient create(io.vertx.mutiny.core.Vertx vertx) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    private MqttClient __connect(int port, String host, final Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.delegate.connect(port, host, (Handler)new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>(){

            public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<MqttConnAckMessage> connect(int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__connect(port, host, (Handler<AsyncResult<MqttConnAckMessage>>)handler));
    }

    public MqttConnAckMessage connectAndAwait(int port, String host) {
        return (MqttConnAckMessage)this.connect(port, host).await().indefinitely();
    }

    private MqttClient __connect(int port, String host, String serverName, final Handler<AsyncResult<MqttConnAckMessage>> connectHandler) {
        this.delegate.connect(port, host, serverName, (Handler)new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>(){

            public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<MqttConnAckMessage> connect(int port, String host, String serverName) {
        return AsyncResultUni.toUni(handler -> this.__connect(port, host, serverName, (Handler<AsyncResult<MqttConnAckMessage>>)handler));
    }

    public MqttConnAckMessage connectAndAwait(int port, String host, String serverName) {
        return (MqttConnAckMessage)this.connect(port, host, serverName).await().indefinitely();
    }

    private MqttClient __disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        this.delegate.disconnect(disconnectHandler);
        return this;
    }

    public Uni<Void> disconnect() {
        return AsyncResultUni.toUni(handler -> this.__disconnect((Handler<AsyncResult<Void>>)handler));
    }

    public Void disconnectAndAwait() {
        return (Void)this.disconnect().await().indefinitely();
    }

    private MqttClient __publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
        return this;
    }

    public Uni<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultUni.toUni(handler -> this.__publish(topic, payload, qosLevel, isDup, isRetain, (Handler<AsyncResult<Integer>>)handler));
    }

    public Integer publishAndAwait(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return (Integer)this.publish(topic, payload, qosLevel, isDup, isRetain).await().indefinitely();
    }

    private MqttClient __publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.delegate.publishCompletionHandler(publishCompletionHandler);
        return this;
    }

    public MqttClient publishCompletionHandler(Consumer<Integer> publishCompletionHandler) {
        return this.__publishCompletionHandler(publishCompletionHandler != null ? publishCompletionHandler::accept : null);
    }

    private MqttClient __publishCompletionExpirationHandler(Handler<Integer> publishCompletionExpirationHandler) {
        this.delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
        return this;
    }

    public MqttClient publishCompletionExpirationHandler(Consumer<Integer> publishCompletionExpirationHandler) {
        return this.__publishCompletionExpirationHandler(publishCompletionExpirationHandler != null ? publishCompletionExpirationHandler::accept : null);
    }

    private MqttClient __publishCompletionUnknownPacketIdHandler(Handler<Integer> publishCompletionPhantomHandler) {
        this.delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
        return this;
    }

    public MqttClient publishCompletionUnknownPacketIdHandler(Consumer<Integer> publishCompletionPhantomHandler) {
        return this.__publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler != null ? publishCompletionPhantomHandler::accept : null);
    }

    private MqttClient __publishHandler(final Handler<MqttPublishMessage> publishHandler) {
        this.delegate.publishHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttPublishMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
                publishHandler.handle((Object)MqttPublishMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttClient publishHandler(Consumer<MqttPublishMessage> publishHandler) {
        return this.__publishHandler(publishHandler != null ? publishHandler::accept : null);
    }

    private MqttClient __subscribeCompletionHandler(final Handler<MqttSubAckMessage> subscribeCompletionHandler) {
        this.delegate.subscribeCompletionHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttSubAckMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttSubAckMessage event) {
                subscribeCompletionHandler.handle((Object)MqttSubAckMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttClient subscribeCompletionHandler(Consumer<MqttSubAckMessage> subscribeCompletionHandler) {
        return this.__subscribeCompletionHandler(subscribeCompletionHandler != null ? subscribeCompletionHandler::accept : null);
    }

    private MqttClient __subscribe(String topic, int qos, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        this.delegate.subscribe(topic, qos, subscribeSentHandler);
        return this;
    }

    public Uni<Integer> subscribe(String topic, int qos) {
        return AsyncResultUni.toUni(handler -> this.__subscribe(topic, qos, (Handler<AsyncResult<Integer>>)handler));
    }

    public Integer subscribeAndAwait(String topic, int qos) {
        return (Integer)this.subscribe(topic, qos).await().indefinitely();
    }

    private MqttClient __subscribe(Map<String, Integer> topics, Handler<AsyncResult<Integer>> subscribeSentHandler) {
        this.delegate.subscribe(topics, subscribeSentHandler);
        return this;
    }

    public Uni<Integer> subscribe(Map<String, Integer> topics) {
        return AsyncResultUni.toUni(handler -> this.__subscribe(topics, (Handler<AsyncResult<Integer>>)handler));
    }

    public Integer subscribeAndAwait(Map<String, Integer> topics) {
        return (Integer)this.subscribe(topics).await().indefinitely();
    }

    private MqttClient __unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
        return this;
    }

    public MqttClient unsubscribeCompletionHandler(Consumer<Integer> unsubscribeCompletionHandler) {
        return this.__unsubscribeCompletionHandler(unsubscribeCompletionHandler != null ? unsubscribeCompletionHandler::accept : null);
    }

    private MqttClient __unsubscribe(String topic, Handler<AsyncResult<Integer>> unsubscribeSentHandler) {
        this.delegate.unsubscribe(topic, unsubscribeSentHandler);
        return this;
    }

    public Uni<Integer> unsubscribe(String topic) {
        return AsyncResultUni.toUni(handler -> this.__unsubscribe(topic, (Handler<AsyncResult<Integer>>)handler));
    }

    public Integer unsubscribeAndAwait(String topic) {
        return (Integer)this.unsubscribe(topic).await().indefinitely();
    }

    private MqttClient __pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.delegate.pingResponseHandler(pingResponseHandler);
        return this;
    }

    public MqttClient pingResponseHandler(Consumer<Void> pingResponseHandler) {
        return this.__pingResponseHandler(pingResponseHandler != null ? pingResponseHandler::accept : null);
    }

    private MqttClient __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttClient exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private MqttClient __closeHandler(Handler<Void> closeHandler) {
        this.delegate.closeHandler(closeHandler);
        return this;
    }

    public MqttClient closeHandler(Consumer<Void> closeHandler) {
        return this.__closeHandler(closeHandler != null ? closeHandler::accept : null);
    }

    public MqttClient ping() {
        this.delegate.ping();
        return this;
    }

    public String clientId() {
        String ret = this.delegate.clientId();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public MqttClient disconnectAndForget() {
        this.delegate.disconnect();
        return this;
    }

    public MqttClient publishAndForget(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain);
        return this;
    }

    public MqttClient subscribeAndForget(String topic, int qos) {
        this.delegate.subscribe(topic, qos);
        return this;
    }

    public MqttClient subscribeAndForget(Map<String, Integer> topics) {
        this.delegate.subscribe(topics);
        return this;
    }

    public MqttClient unsubscribeAndForget(String topic) {
        this.delegate.unsubscribe(topic);
        return this;
    }

    public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
        return arg != null ? new MqttClient(arg) : null;
    }
}

