package io.vertx.mutiny.mqtt;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An MQTT server
 * <p>
 *    You can accept incoming MQTT connection requests providing a {@link io.vertx.mutiny.mqtt.MqttServer#endpointHandler}. As the
 *    requests arrive, the handler will be called with an instance of {@link io.vertx.mutiny.mqtt.MqttEndpoint} in order to manage the
 *    communication with the remote MQTT client.
 * </p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.MqttServer.class)
public class MqttServer {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttServer((io.vertx.mqtt.MqttServer) obj),
    MqttServer::getDelegate
  );

  private final io.vertx.mqtt.MqttServer delegate;
  
  public MqttServer(io.vertx.mqtt.MqttServer delegate) {
    this.delegate = delegate;
  }

  public MqttServer(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttServer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttServer() {
    this.delegate = null;
  }

  public io.vertx.mqtt.MqttServer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttServer that = (MqttServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx Vert.x instance
   * @param options MQTT server options
   * @return MQTT server instance
   */
  public static io.vertx.mutiny.mqtt.MqttServer create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mqtt.MqttServerOptions options) { 
    io.vertx.mutiny.mqtt.MqttServer ret = io.vertx.mutiny.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)io.vertx.mqtt.MqttServer.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx Vert.x instance
   * @return MQTT server instance
   */
  public static io.vertx.mutiny.mqtt.MqttServer create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.mqtt.MqttServer ret = io.vertx.mutiny.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)io.vertx.mqtt.MqttServer.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Start the server listening for incoming connections on the port and host specified
   * It ignores any options specified through the constructor
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.mqtt.MqttServer> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(listenHandler -> {
        delegate.listen(port, host, new io.smallrye.mutiny.vertx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.mutiny.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttServer#listen(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the MqttServer instance produced by the operation.
   */
  public io.vertx.mutiny.mqtt.MqttServer listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.mqtt.MqttServer) listen(port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttServer#listen(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttServer#listen(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttServer#listen(int,String)} but you don't need to compose it with other operations.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the instance of MqttServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttServer listenAndForget(int port, String host) { 
    listen(port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Start the server listening for incoming connections on the port specified but on
   * "0.0.0.0" as host. It ignores any options specified through the constructor
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.mqtt.MqttServer> listen(int port) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(listenHandler -> {
        delegate.listen(port, new io.smallrye.mutiny.vertx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.mutiny.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttServer#listen(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @return the MqttServer instance produced by the operation.
   */
  public io.vertx.mutiny.mqtt.MqttServer listenAndAwait(int port) { 
    return (io.vertx.mutiny.mqtt.MqttServer) listen(port).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttServer#listen(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttServer#listen(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttServer#listen(int)} but you don't need to compose it with other operations.
   * @param port the port to listen on
   * @return the instance of MqttServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttServer listenAndForget(int port) { 
    listen(port).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Start the server listening for incoming connections using the specified options
   * through the constructor
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.mqtt.MqttServer> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(listenHandler -> {
        delegate.listen(new io.smallrye.mutiny.vertx.DelegatingHandler<>(listenHandler, ar -> ar.map(event -> io.vertx.mutiny.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttServer#listen}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the MqttServer instance produced by the operation.
   */
  public io.vertx.mutiny.mqtt.MqttServer listenAndAwait() { 
    return (io.vertx.mutiny.mqtt.MqttServer) listen().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttServer#listen} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttServer#listen}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttServer#listen} but you don't need to compose it with other operations.
   * @return the instance of MqttServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttServer listenAndForget() { 
    listen().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler the endpoint handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttServer __endpointHandler(Handler<io.vertx.mutiny.mqtt.MqttEndpoint> handler) { 
    delegate.endpointHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.MqttEndpoint.newInstance((io.vertx.mqtt.MqttEndpoint)event)));
    return this;
  }

  /**
   * @param handler the endpoint handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttServer endpointHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.MqttEndpoint> handler) {
    return __endpointHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttServer __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the exception handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttServer exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Close the server supplying an handler that will be called when the server is actually closed (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttServer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttServer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttServer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttServer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  MqttServer newInstance(io.vertx.mqtt.MqttServer arg) {
    return arg != null ? new MqttServer(arg) : null;
  }

}
