package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mqtt.messages.codes.MqttPubRelReasonCode;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT PUBREL message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPubRelMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttPubRelMessage.class)
public class MqttPubRelMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttPubRelMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttPubRelMessage((io.vertx.mqtt.messages.MqttPubRelMessage) obj),
    MqttPubRelMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPubRelMessage delegate;
  
  public MqttPubRelMessage(io.vertx.mqtt.messages.MqttPubRelMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPubRelMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPubRelMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttPubRelMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttPubRelMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPubRelMessage that = (MqttPubRelMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return reason code from the pubrel request
   */
  public io.vertx.mqtt.messages.codes.MqttPubRelReasonCode code() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mqtt.messages.codes.MqttPubRelReasonCode ret = delegate.code();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param messageId message Id
   * @param code return code from the pubrel
   * @param properties MQTT properties of the pubrel message
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttPubRelMessage create(int messageId, io.vertx.mqtt.messages.codes.MqttPubRelReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttPubRelMessage ret = io.vertx.mutiny.mqtt.messages.MqttPubRelMessage.newInstance((io.vertx.mqtt.messages.MqttPubRelMessage)io.vertx.mqtt.messages.MqttPubRelMessage.create(messageId, code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.vertx.mqtt.messages.codes.MqttPubRelReasonCode cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttPubRelMessage newInstance(io.vertx.mqtt.messages.MqttPubRelMessage arg) {
    return arg != null ? new MqttPubRelMessage(arg) : null;
  }

}
