package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT PUBLISH message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPublishMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttPublishMessage.class)
public class MqttPublishMessage implements io.vertx.mutiny.mqtt.messages.MqttMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttPublishMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttPublishMessage((io.vertx.mqtt.messages.MqttPublishMessage) obj),
    MqttPublishMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPublishMessage delegate;
  
  public MqttPublishMessage(io.vertx.mqtt.messages.MqttPublishMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPublishMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPublishMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttPublishMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttPublishMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPublishMessage that = (MqttPublishMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return Quality of service level
   */
  public io.netty.handler.codec.mqtt.MqttQoS qosLevel() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.netty.handler.codec.mqtt.MqttQoS ret = delegate.qosLevel();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return If the message is a duplicate
   */
  public boolean isDup() { 
    if (cached_2 != null) {
      return cached_2;
    }
    boolean ret = delegate.isDup();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return If the message needs to be retained
   */
  public boolean isRetain() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isRetain();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return Topic on which the message was published
   */
  public String topicName() { 
    if (cached_4 != null) {
      return cached_4;
    }
    String ret = delegate.topicName();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return Payload message
   */
  public io.vertx.mutiny.core.buffer.Buffer payload() { 
    if (cached_5 != null) {
      return cached_5;
    }
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.payload());
    cached_5 = ret;
    return ret;
  }

  /**
   * @param messageId message identifier
   * @param qosLevel quality of service level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param topicName topic on which the message was published
   * @param payload payload message
   * @param properties message properties
   * @return Vert.x publish message
   */
  public static io.vertx.mutiny.mqtt.messages.MqttPublishMessage create(int messageId, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, String topicName, io.netty.buffer.ByteBuf payload, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttPublishMessage ret = io.vertx.mutiny.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)io.vertx.mqtt.messages.MqttPublishMessage.create(messageId, qosLevel, isDup, isRetain, topicName, payload, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_6 != null) {
      return cached_6;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_6 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.netty.handler.codec.mqtt.MqttQoS cached_1;
  private java.lang.Boolean cached_2;
  private java.lang.Boolean cached_3;
  private String cached_4;
  private io.vertx.mutiny.core.buffer.Buffer cached_5;
  private io.netty.handler.codec.mqtt.MqttProperties cached_6;
  public static  MqttPublishMessage newInstance(io.vertx.mqtt.messages.MqttPublishMessage arg) {
    return arg != null ? new MqttPublishMessage(arg) : null;
  }

}
