package io.vertx.mutiny.mqtt;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Future;
import io.vertx.mqtt.MqttClientOptions;
import java.util.List;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.MqttClient.class)
public class MqttClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttClient((io.vertx.mqtt.MqttClient) obj),
    MqttClient::getDelegate
  );

  private final io.vertx.mqtt.MqttClient delegate;
  
  public MqttClient(io.vertx.mqtt.MqttClient delegate) {
    this.delegate = delegate;
  }

  public MqttClient(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttClient() {
    this.delegate = null;
  }

  public io.vertx.mqtt.MqttClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttClient that = (MqttClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx Vert.x instance
   * @param options MQTT client options
   * @return MQTT client instance
   */
  public static io.vertx.mutiny.mqtt.MqttClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mqtt.MqttClientOptions options) { 
    io.vertx.mutiny.mqtt.MqttClient ret = io.vertx.mutiny.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx Vert.x instance
   * @return MQTT client instance
   */
  public static io.vertx.mutiny.mqtt.MqttClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.mqtt.MqttClient ret = io.vertx.mutiny.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.mqtt.messages.MqttConnAckMessage> connect(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectHandler -> {
        delegate.connect(port, host, new io.smallrye.mutiny.vertx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.mutiny.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return the MqttConnAckMessage instance produced by the operation.
   */
  public io.vertx.mutiny.mqtt.messages.MqttConnAckMessage connectAndAwait(int port, String host) { 
    return (io.vertx.mutiny.mqtt.messages.MqttConnAckMessage) connect(port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String)} but you don't need to compose it with other operations.
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient connectAndForget(int port, String host) { 
    connect(port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.mqtt.messages.MqttConnAckMessage> connect(int port, String host, String serverName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectHandler -> {
        delegate.connect(port, host, serverName, new io.smallrye.mutiny.vertx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.mutiny.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return the MqttConnAckMessage instance produced by the operation.
   */
  public io.vertx.mutiny.mqtt.messages.MqttConnAckMessage connectAndAwait(int port, String host, String serverName) { 
    return (io.vertx.mutiny.mqtt.messages.MqttConnAckMessage) connect(port, host, serverName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#connect(int,String,String)} but you don't need to compose it with other operations.
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient connectAndForget(int port, String host, String serverName) { 
    connect(port, host, serverName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> disconnect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(disconnectHandler -> {
        delegate.disconnect(disconnectHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#disconnect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void disconnectAndAwait() { 
    return (Void) disconnect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#disconnect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#disconnect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#disconnect} but you don't need to compose it with other operations.
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient disconnectAndForget() { 
    disconnect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> publish(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(publishSentHandler -> {
        delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return the Integer instance produced by the operation.
   */
  public Integer publishAndAwait(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return (Integer) publish(topic, payload, qosLevel, isDup, isRetain).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)} but you don't need to compose it with other operations.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient publishAndForget(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    publish(topic, payload, qosLevel, isDup, isRetain).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param publishCompletionHandler handler called with the packetId
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __publishCompletionHandler(Handler<Integer> publishCompletionHandler) { 
    delegate.publishCompletionHandler(publishCompletionHandler);
    return this;
  }

  /**
   * @param publishCompletionHandler handler called with the packetId
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient publishCompletionHandler(java.util.function.Consumer<Integer> publishCompletionHandler) {
    return __publishCompletionHandler(publishCompletionHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(publishCompletionHandler) : null);
  }

  /**
   * @param publishCompletionExpirationHandler the handler to call with the ID of the expired packet
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __publishCompletionExpirationHandler(Handler<Integer> publishCompletionExpirationHandler) { 
    delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
    return this;
  }

  /**
   * @param publishCompletionExpirationHandler the handler to call with the ID of the expired packet
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient publishCompletionExpirationHandler(java.util.function.Consumer<Integer> publishCompletionExpirationHandler) {
    return __publishCompletionExpirationHandler(publishCompletionExpirationHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(publishCompletionExpirationHandler) : null);
  }

  /**
   * @param publishCompletionPhantomHandler the handler to call with the unknown packet ID
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __publishCompletionUnknownPacketIdHandler(Handler<Integer> publishCompletionPhantomHandler) { 
    delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
    return this;
  }

  /**
   * @param publishCompletionPhantomHandler the handler to call with the unknown packet ID
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient publishCompletionUnknownPacketIdHandler(java.util.function.Consumer<Integer> publishCompletionPhantomHandler) {
    return __publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(publishCompletionPhantomHandler) : null);
  }

  /**
   * @param publishHandler handler to call
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __publishHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttPublishMessage> publishHandler) { 
    delegate.publishHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(publishHandler, event -> io.vertx.mutiny.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)event)));
    return this;
  }

  /**
   * @param publishHandler handler to call
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient publishHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttPublishMessage> publishHandler) {
    return __publishHandler(publishHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(publishHandler) : null);
  }

  /**
   * @param subscribeCompletionHandler handler to call. List inside is a granted QoS array
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __subscribeCompletionHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler) { 
    delegate.subscribeCompletionHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(subscribeCompletionHandler, event -> io.vertx.mutiny.mqtt.messages.MqttSubAckMessage.newInstance((io.vertx.mqtt.messages.MqttSubAckMessage)event)));
    return this;
  }

  /**
   * @param subscribeCompletionHandler handler to call. List inside is a granted QoS array
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient subscribeCompletionHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler) {
    return __subscribeCompletionHandler(subscribeCompletionHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(subscribeCompletionHandler) : null);
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> subscribe(String topic, int qos) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(subscribeSentHandler -> {
        delegate.subscribe(topic, qos, subscribeSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(String,int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return the Integer instance produced by the operation.
   */
  public Integer subscribeAndAwait(String topic, int qos) { 
    return (Integer) subscribe(topic, qos).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(String,int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(String,int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(String,int)} but you don't need to compose it with other operations.
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient subscribeAndForget(String topic, int qos) { 
    subscribe(topic, qos).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topics topics you subscribe on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> subscribe(java.util.Map<String, Integer> topics) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(subscribeSentHandler -> {
        delegate.subscribe(topics, subscribeSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topics topics you subscribe on
   * @return the Integer instance produced by the operation.
   */
  public Integer subscribeAndAwait(java.util.Map<String, Integer> topics) { 
    return (Integer) subscribe(topics).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#subscribe(Map)} but you don't need to compose it with other operations.
   * @param topics topics you subscribe on
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient subscribeAndForget(java.util.Map<String, Integer> topics) { 
    subscribe(topics).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param unsubscribeCompletionHandler handler to call with the packetid
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) { 
    delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
    return this;
  }

  /**
   * @param unsubscribeCompletionHandler handler to call with the packetid
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient unsubscribeCompletionHandler(java.util.function.Consumer<Integer> unsubscribeCompletionHandler) {
    return __unsubscribeCompletionHandler(unsubscribeCompletionHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(unsubscribeCompletionHandler) : null);
  }

  /**
   * Unsubscribe from receiving messages on given topics
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topics list of topics you want to unsubscribe from
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> unsubscribe(List<String> topics) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(unsubscribeSentHandler -> {
        delegate.unsubscribe(topics, unsubscribeSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topics list of topics you want to unsubscribe from
   * @return the Integer instance produced by the operation.
   */
  public Integer unsubscribeAndAwait(List<String> topics) { 
    return (Integer) unsubscribe(topics).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(List)} but you don't need to compose it with other operations.
   * @param topics list of topics you want to unsubscribe from
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient unsubscribeAndForget(List<String> topics) { 
    unsubscribe(topics).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic list of topics you want to unsubscribe from
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> unsubscribe(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(unsubscribeSentHandler -> {
        delegate.unsubscribe(topic, unsubscribeSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic list of topics you want to unsubscribe from
   * @return the Integer instance produced by the operation.
   */
  public Integer unsubscribeAndAwait(String topic) { 
    return (Integer) unsubscribe(topic).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttClient#unsubscribe(String)} but you don't need to compose it with other operations.
   * @param topic list of topics you want to unsubscribe from
   * @return the instance of MqttClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient unsubscribeAndForget(String topic) { 
    unsubscribe(topic).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param pingResponseHandler handler to call
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __pingResponseHandler(Handler<Void> pingResponseHandler) { 
    delegate.pingResponseHandler(pingResponseHandler);
    return this;
  }

  /**
   * @param pingResponseHandler handler to call
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient pingResponseHandler(java.lang.Runnable pingResponseHandler) {
    return __pingResponseHandler(ignored -> pingResponseHandler.run()
);
  }

  /**
   * @param handler the exception handler
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the exception handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param closeHandler handler to call
   * @return current MQTT client instance
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttClient __closeHandler(Handler<Void> closeHandler) { 
    delegate.closeHandler(closeHandler);
    return this;
  }

  /**
   * @param closeHandler handler to call
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttClient closeHandler(java.lang.Runnable closeHandler) {
    return __closeHandler(ignored -> closeHandler.run()
);
  }

  /**
   * @return current MQTT client instance
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttClient ping() { 
    delegate.ping();
    return this;
  }

  /**
   * @return the client identifier
   */
  public String clientId() { 
    String ret = delegate.clientId();
    return ret;
  }

  /**
   * @return if the connection between client and remote server is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  public static  MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
    return arg != null ? new MqttClient(arg) : null;
  }

}
