package io.vertx.mutiny.mqtt;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mqtt.messages.codes.MqttPubCompReasonCode;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.vertx.mqtt.messages.codes.MqttSubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRelReasonCode;
import io.vertx.core.AsyncResult;
import io.vertx.mqtt.messages.codes.MqttPubRecReasonCode;
import io.vertx.core.Future;
import io.vertx.mqtt.messages.codes.MqttPubAckReasonCode;
import java.util.List;
import io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.core.Handler;

/**
 * Represents an MQTT endpoint for point-to-point communication with the remote MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttEndpoint original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.MqttEndpoint.class)
public class MqttEndpoint {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttEndpoint> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttEndpoint((io.vertx.mqtt.MqttEndpoint) obj),
    MqttEndpoint::getDelegate
  );

  private final io.vertx.mqtt.MqttEndpoint delegate;
  
  public MqttEndpoint(io.vertx.mqtt.MqttEndpoint delegate) {
    this.delegate = delegate;
  }

  public MqttEndpoint(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttEndpoint)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttEndpoint() {
    this.delegate = null;
  }

  public io.vertx.mqtt.MqttEndpoint getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttEndpoint that = (MqttEndpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the remote address for this socket
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.mqtt.MqttEndpoint} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return the HTTP headers
   */
  public io.vertx.mutiny.core.MultiMap httpHeaders() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.httpHeaders());
    return ret;
  }

  /**
   * @return the HTTP request uri
   */
  public String httpRequestURI() { 
    String ret = delegate.httpRequestURI();
    return ret;
  }

  /**
   * @return the client identifier as provided by the remote MQTT client
   */
  public String clientIdentifier() { 
    if (cached_2 != null) {
      return cached_2;
    }
    String ret = delegate.clientIdentifier();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the Authentication information as provided by the remote MQTT client
   */
  public io.vertx.mqtt.MqttAuth auth() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.mqtt.MqttAuth ret = delegate.auth();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the Will information as provided by the remote MQTT client
   */
  public io.vertx.mqtt.MqttWill will() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.mqtt.MqttWill ret = delegate.will();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the protocol version required by the remote MQTT client
   */
  public int protocolVersion() { 
    if (cached_5 != null) {
      return cached_5;
    }
    int ret = delegate.protocolVersion();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the protocol name provided by the remote MQTT client
   */
  public String protocolName() { 
    if (cached_6 != null) {
      return cached_6;
    }
    String ret = delegate.protocolName();
    cached_6 = ret;
    return ret;
  }

  /**
   * @return true when clean session is requested by the remote MQTT client
   */
  public boolean isCleanSession() { 
    if (cached_7 != null) {
      return cached_7;
    }
    boolean ret = delegate.isCleanSession();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the keep alive timeout (in seconds) specified by the remote MQTT client
   */
  public int keepAliveTimeSeconds() { 
    if (cached_8 != null) {
      return cached_8;
    }
    int ret = delegate.keepAliveTimeSeconds();
    cached_8 = ret;
    return ret;
  }

  /**
   * @return the message identifier used for last published message
   */
  public int lastMessageId() { 
    if (cached_9 != null) {
      return cached_9;
    }
    int ret = delegate.lastMessageId();
    cached_9 = ret;
    return ret;
  }

  /**
   * @param isSubscriptionAutoAck auto acknowledge status
   */
  public void subscriptionAutoAck(boolean isSubscriptionAutoAck) { 
    delegate.subscriptionAutoAck(isSubscriptionAutoAck);
  }

  /**
   * @return true when auto acknowledge status for subscription/unsubscription requests
   */
  public boolean isSubscriptionAutoAck() { 
    boolean ret = delegate.isSubscriptionAutoAck();
    return ret;
  }

  /**
   * @param isPublishAutoAck auto acknowledge status
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAutoAck(boolean isPublishAutoAck) { 
    delegate.publishAutoAck(isPublishAutoAck);
    return this;
  }

  /**
   * @return auto acknowledge status for publishing (in/out)
   */
  public boolean isPublishAutoAck() { 
    boolean ret = delegate.isPublishAutoAck();
    return ret;
  }

  /**
   * @param isAutoKeepAlive auto keep alive
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) { 
    delegate.autoKeepAlive(isAutoKeepAlive);
    return this;
  }

  /**
   * @return the auto keep alive status (sending ping response)
   */
  public boolean isAutoKeepAlive() { 
    boolean ret = delegate.isAutoKeepAlive();
    return ret;
  }

  /**
   * @return if the connection between remote client and local endpoint is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * @param clientIdentifier the client identifier
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint setClientIdentifier(String clientIdentifier) { 
    delegate.setClientIdentifier(clientIdentifier);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __disconnectHandler(Handler<Void> handler) { 
    delegate.disconnectHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint disconnectHandler(java.lang.Runnable handler) {
    return __disconnectHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __disconnectMessageHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage> handler) { 
    delegate.disconnectMessageHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage.newInstance((io.vertx.mqtt.messages.MqttDisconnectMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint disconnectMessageHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage> handler) {
    return __disconnectMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __subscribeHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage> handler) { 
    delegate.subscribeHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttSubscribeMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint subscribeHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage> handler) {
    return __subscribeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __unsubscribeHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage> handler) { 
    delegate.unsubscribeHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttUnsubscribeMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint unsubscribeHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage> handler) {
    return __unsubscribeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttPublishMessage> handler) { 
    delegate.publishHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttPublishMessage> handler) {
    return __publishHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishAcknowledgeHandler(Handler<Integer> handler) { 
    delegate.publishAcknowledgeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAcknowledgeHandler(java.util.function.Consumer<Integer> handler) {
    return __publishAcknowledgeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishAcknowledgeMessageHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttPubAckMessage> handler) { 
    delegate.publishAcknowledgeMessageHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttPubAckMessage.newInstance((io.vertx.mqtt.messages.MqttPubAckMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAcknowledgeMessageHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttPubAckMessage> handler) {
    return __publishAcknowledgeMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishReceivedHandler(Handler<Integer> handler) { 
    delegate.publishReceivedHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishReceivedHandler(java.util.function.Consumer<Integer> handler) {
    return __publishReceivedHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishReceivedMessageHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttPubRecMessage> handler) { 
    delegate.publishReceivedMessageHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttPubRecMessage.newInstance((io.vertx.mqtt.messages.MqttPubRecMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishReceivedMessageHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttPubRecMessage> handler) {
    return __publishReceivedMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishReleaseHandler(Handler<Integer> handler) { 
    delegate.publishReleaseHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishReleaseHandler(java.util.function.Consumer<Integer> handler) {
    return __publishReleaseHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishReleaseMessageHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttPubRelMessage> handler) { 
    delegate.publishReleaseMessageHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttPubRelMessage.newInstance((io.vertx.mqtt.messages.MqttPubRelMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishReleaseMessageHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttPubRelMessage> handler) {
    return __publishReleaseMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishCompletionHandler(Handler<Integer> handler) { 
    delegate.publishCompletionHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishCompletionHandler(java.util.function.Consumer<Integer> handler) {
    return __publishCompletionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __publishCompletionMessageHandler(Handler<io.vertx.mutiny.mqtt.messages.MqttPubCompMessage> handler) { 
    delegate.publishCompletionMessageHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.mqtt.messages.MqttPubCompMessage.newInstance((io.vertx.mqtt.messages.MqttPubCompMessage)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint publishCompletionMessageHandler(java.util.function.Consumer<io.vertx.mutiny.mqtt.messages.MqttPubCompMessage> handler) {
    return __publishCompletionMessageHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __pingHandler(Handler<Void> handler) { 
    delegate.pingHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint pingHandler(java.lang.Runnable handler) {
    return __pingHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mqtt.MqttEndpoint __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mqtt.MqttEndpoint exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @return the instance of MqttEndpoint to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint accept() { 
    delegate.accept();
    return this;
  }

  /**
   * @param sessionPresent if a previous session is present
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint accept(boolean sessionPresent) { 
    delegate.accept(sessionPresent);
    return this;
  }

  /**
   * @param returnCode the connect return code
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint reject(io.netty.handler.codec.mqtt.MqttConnectReturnCode returnCode) { 
    delegate.reject(returnCode);
    return this;
  }

  /**
   * @param subscribeMessageId identifier of the SUBSCRIBE message to acknowledge
   * @param grantedQoSLevels granted QoS levels for the requested topics
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<io.netty.handler.codec.mqtt.MqttQoS> grantedQoSLevels) { 
    delegate.subscribeAcknowledge(subscribeMessageId, grantedQoSLevels);
    return this;
  }

  /**
   * @param unsubscribeMessageId identifier of the UNSUBSCRIBE message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId) { 
    delegate.unsubscribeAcknowledge(unsubscribeMessageId);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAcknowledge(int publishMessageId) { 
    delegate.publishAcknowledge(publishMessageId);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishReceived(int publishMessageId) { 
    delegate.publishReceived(publishMessageId);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishRelease(int publishMessageId) { 
    delegate.publishRelease(publishMessageId);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishComplete(int publishMessageId) { 
    delegate.publishComplete(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> publish(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(publishSentHandler -> {
        delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return the Integer instance produced by the operation.
   */
  public Integer publishAndAwait(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return (Integer) publish(topic, payload, qosLevel, isDup, isRetain).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean)} but you don't need to compose it with other operations.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return the instance of MqttEndpoint to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAndForget(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    publish(topic, payload, qosLevel, isDup, isRetain).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> publish(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(publishSentHandler -> {
        delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, publishSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @return the Integer instance produced by the operation.
   */
  public Integer publishAndAwait(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) { 
    return (Integer) publish(topic, payload, qosLevel, isDup, isRetain, messageId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int)} but you don't need to compose it with other operations.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @return the instance of MqttEndpoint to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAndForget(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) { 
    publish(topic, payload, qosLevel, isDup, isRetain, messageId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint pong() { 
    delegate.pong();
    return this;
  }

  /**
   * @return MQTT properties of the CONNECT message
   */
  public io.netty.handler.codec.mqtt.MqttProperties connectProperties() { 
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.connectProperties();
    return ret;
  }

  /**
   * @param sessionPresent if a previous session is present
   * @param properties CONNACK message properties (MQTT5)
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint accept(boolean sessionPresent, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.accept(sessionPresent, properties);
    return this;
  }

  /**
   * @param returnCode the connect return code
   * @param properties CONNACK message properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint reject(io.netty.handler.codec.mqtt.MqttConnectReturnCode returnCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.reject(returnCode, properties);
    return this;
  }

  /**
   * @param subscribeMessageId identifier of the SUBSCRIBE message to acknowledge
   * @param reasonCodes reason codes
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<io.vertx.mqtt.messages.codes.MqttSubAckReasonCode> reasonCodes, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.subscribeAcknowledge(subscribeMessageId, reasonCodes, properties);
    return this;
  }

  /**
   * @param unsubscribeMessageId identifier of the UNSUBSCRIBE message to acknowledge
   * @param reasonCodes reason codes
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId, List<io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode> reasonCodes, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.unsubscribeAcknowledge(unsubscribeMessageId, reasonCodes, properties);
    return this;
  }

  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAcknowledge(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubAckReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishAcknowledge(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @param reasonCode code of the outcome
   * @param properties MQTT properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishReceived(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubRecReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishReceived(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @param reasonCode reason code
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishRelease(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubRelReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishRelease(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @param reasonCode reason code
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishComplete(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubCompReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishComplete(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @param properties PUBLISH message properties
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> publish(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(publishSentHandler -> {
        delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, properties, publishSentHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int,MqttProperties)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @param properties PUBLISH message properties
   * @return the Integer instance produced by the operation.
   */
  public Integer publishAndAwait(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    return (Integer) publish(topic, payload, qosLevel, isDup, isRetain, messageId, properties).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int,MqttProperties)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int,MqttProperties)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mqtt.MqttEndpoint#publish(String,io.vertx.mutiny.core.buffer.Buffer,MqttQoS,boolean,boolean,int,MqttProperties)} but you don't need to compose it with other operations.
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @param properties PUBLISH message properties
   * @return the instance of MqttEndpoint to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint publishAndForget(String topic, io.vertx.mutiny.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    publish(topic, payload, qosLevel, isDup, isRetain, messageId, properties).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param code reason code
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.mqtt.MqttEndpoint disconnect(io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.disconnect(code, properties);
    return this;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  private String cached_2;
  private io.vertx.mqtt.MqttAuth cached_3;
  private io.vertx.mqtt.MqttWill cached_4;
  private java.lang.Integer cached_5;
  private String cached_6;
  private java.lang.Boolean cached_7;
  private java.lang.Integer cached_8;
  private java.lang.Integer cached_9;
  public static  MqttEndpoint newInstance(io.vertx.mqtt.MqttEndpoint arg) {
    return arg != null ? new MqttEndpoint(arg) : null;
  }

}
