package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT CONNACK message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttConnAckMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttConnAckMessage.class)
public class MqttConnAckMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttConnAckMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttConnAckMessage((io.vertx.mqtt.messages.MqttConnAckMessage) obj),
    MqttConnAckMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttConnAckMessage delegate;
  
  public MqttConnAckMessage(io.vertx.mqtt.messages.MqttConnAckMessage delegate) {
    this.delegate = delegate;
  }

  public MqttConnAckMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttConnAckMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttConnAckMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttConnAckMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttConnAckMessage that = (MqttConnAckMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param code return code from the connection request
   * @param isSessionPresent is an old session is present
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttConnAckMessage create(io.netty.handler.codec.mqtt.MqttConnectReturnCode code, boolean isSessionPresent) { 
    io.vertx.mutiny.mqtt.messages.MqttConnAckMessage ret = io.vertx.mutiny.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)io.vertx.mqtt.messages.MqttConnAckMessage.create(code, isSessionPresent));
    return ret;
  }

  /**
   * @return return code from the connection request
   */
  public io.netty.handler.codec.mqtt.MqttConnectReturnCode code() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.netty.handler.codec.mqtt.MqttConnectReturnCode ret = delegate.code();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return is an old session is present
   */
  public boolean isSessionPresent() { 
    if (cached_1 != null) {
      return cached_1;
    }
    boolean ret = delegate.isSessionPresent();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param code return code from the connection request
   * @param isSessionPresent is an old session is present
   * @param properties MQTT properties
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttConnAckMessage create(io.netty.handler.codec.mqtt.MqttConnectReturnCode code, boolean isSessionPresent, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttConnAckMessage ret = io.vertx.mutiny.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)io.vertx.mqtt.messages.MqttConnAckMessage.create(code, isSessionPresent, properties));
    return ret;
  }

  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private io.netty.handler.codec.mqtt.MqttConnectReturnCode cached_0;
  private java.lang.Boolean cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttConnAckMessage newInstance(io.vertx.mqtt.messages.MqttConnAckMessage arg) {
    return arg != null ? new MqttConnAckMessage(arg) : null;
  }

}
