package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.mqtt.messages.codes.MqttPubAckReasonCode;

/**
 * Represents an MQTT PUBACK message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPubAckMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttPubAckMessage.class)
public class MqttPubAckMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttPubAckMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttPubAckMessage((io.vertx.mqtt.messages.MqttPubAckMessage) obj),
    MqttPubAckMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPubAckMessage delegate;
  
  public MqttPubAckMessage(io.vertx.mqtt.messages.MqttPubAckMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPubAckMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPubAckMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttPubAckMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttPubAckMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPubAckMessage that = (MqttPubAckMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return reason code from the puback request
   */
  public io.vertx.mqtt.messages.codes.MqttPubAckReasonCode code() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mqtt.messages.codes.MqttPubAckReasonCode ret = delegate.code();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param messageId message Id
   * @param code return code from the puback
   * @param properties MQTT properties of the puback message
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttPubAckMessage create(int messageId, io.vertx.mqtt.messages.codes.MqttPubAckReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttPubAckMessage ret = io.vertx.mutiny.mqtt.messages.MqttPubAckMessage.newInstance((io.vertx.mqtt.messages.MqttPubAckMessage)io.vertx.mqtt.messages.MqttPubAckMessage.create(messageId, code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.vertx.mqtt.messages.codes.MqttPubAckReasonCode cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttPubAckMessage newInstance(io.vertx.mqtt.messages.MqttPubAckMessage arg) {
    return arg != null ? new MqttPubAckMessage(arg) : null;
  }

}
