package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mqtt.messages.codes.MqttPubCompReasonCode;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT PUBCOMP message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPubCompMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttPubCompMessage.class)
public class MqttPubCompMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttPubCompMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttPubCompMessage((io.vertx.mqtt.messages.MqttPubCompMessage) obj),
    MqttPubCompMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPubCompMessage delegate;
  
  public MqttPubCompMessage(io.vertx.mqtt.messages.MqttPubCompMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPubCompMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPubCompMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttPubCompMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttPubCompMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPubCompMessage that = (MqttPubCompMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return reason code from the pubcomp message
   */
  public io.vertx.mqtt.messages.codes.MqttPubCompReasonCode code() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mqtt.messages.codes.MqttPubCompReasonCode ret = delegate.code();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param messageId message Id
   * @param code return code from the pubcomp
   * @param properties MQTT properties of the pubcomp message
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttPubCompMessage create(int messageId, io.vertx.mqtt.messages.codes.MqttPubCompReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttPubCompMessage ret = io.vertx.mutiny.mqtt.messages.MqttPubCompMessage.newInstance((io.vertx.mqtt.messages.MqttPubCompMessage)io.vertx.mqtt.messages.MqttPubCompMessage.create(messageId, code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.vertx.mqtt.messages.codes.MqttPubCompReasonCode cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttPubCompMessage newInstance(io.vertx.mqtt.messages.MqttPubCompMessage arg) {
    return arg != null ? new MqttPubCompMessage(arg) : null;
  }

}
