package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * Represents an MQTT SUBACK message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttSubAckMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttSubAckMessage.class)
public class MqttSubAckMessage implements io.vertx.mutiny.mqtt.messages.MqttMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttSubAckMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttSubAckMessage((io.vertx.mqtt.messages.MqttSubAckMessage) obj),
    MqttSubAckMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttSubAckMessage delegate;
  
  public MqttSubAckMessage(io.vertx.mqtt.messages.MqttSubAckMessage delegate) {
    this.delegate = delegate;
  }

  public MqttSubAckMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttSubAckMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttSubAckMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttSubAckMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttSubAckMessage that = (MqttSubAckMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return list of granted QoS levels
   */
  public List<Integer> grantedQoSLevels() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<Integer> ret = delegate.grantedQoSLevels();
    cached_1 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private List<Integer> cached_1;
  public static  MqttSubAckMessage newInstance(io.vertx.mqtt.messages.MqttSubAckMessage arg) {
    return arg != null ? new MqttSubAckMessage(arg) : null;
  }

}
