package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT CONNACK message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttDisconnectMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttDisconnectMessage.class)
public class MqttDisconnectMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttDisconnectMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttDisconnectMessage((io.vertx.mqtt.messages.MqttDisconnectMessage) obj),
    MqttDisconnectMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttDisconnectMessage delegate;
  
  public MqttDisconnectMessage(io.vertx.mqtt.messages.MqttDisconnectMessage delegate) {
    this.delegate = delegate;
  }

  public MqttDisconnectMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttDisconnectMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttDisconnectMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttDisconnectMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttDisconnectMessage that = (MqttDisconnectMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return return code from the connection request
   */
  public io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode code() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode ret = delegate.code();
    cached_0 = ret;
    return ret;
  }

  /**
   * @param code return code from the disconnect request
   * @param properties MQTT properties of the disconnect message
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage create(io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage ret = io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage.newInstance((io.vertx.mqtt.messages.MqttDisconnectMessage)io.vertx.mqtt.messages.MqttDisconnectMessage.create(code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_1 = ret;
    return ret;
  }

  private io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode cached_0;
  private io.netty.handler.codec.mqtt.MqttProperties cached_1;
  public static  MqttDisconnectMessage newInstance(io.vertx.mqtt.messages.MqttDisconnectMessage arg) {
    return arg != null ? new MqttDisconnectMessage(arg) : null;
  }

}
