package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Represent the interface for each MQTT message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttMessage.class)
public interface MqttMessage {

  io.vertx.mqtt.messages.MqttMessage getDelegate();

  /**
   * @return Message identifier
   */
  public int messageId();

  public static  MqttMessage newInstance(io.vertx.mqtt.messages.MqttMessage arg) {
    return arg != null ? new MqttMessageImpl(arg) : null;
  }

}

class MqttMessageImpl implements MqttMessage {
  private final io.vertx.mqtt.messages.MqttMessage delegate;
  
  public io.vertx.mqtt.messages.MqttMessage getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttMessageImpl() {
    this.delegate = null;
  }

  public MqttMessageImpl(io.vertx.mqtt.messages.MqttMessage delegate) {
    this.delegate = delegate;
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
}
