package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT UNSUBSCRIBE message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttUnsubscribeMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttUnsubscribeMessage.class)
public class MqttUnsubscribeMessage implements io.vertx.mutiny.mqtt.messages.MqttMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttUnsubscribeMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttUnsubscribeMessage((io.vertx.mqtt.messages.MqttUnsubscribeMessage) obj),
    MqttUnsubscribeMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttUnsubscribeMessage delegate;
  
  public MqttUnsubscribeMessage(io.vertx.mqtt.messages.MqttUnsubscribeMessage delegate) {
    this.delegate = delegate;
  }

  public MqttUnsubscribeMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttUnsubscribeMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttUnsubscribeMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttUnsubscribeMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttUnsubscribeMessage that = (MqttUnsubscribeMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return List of topics to unsubscribe
   */
  public List<String> topics() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<String> ret = delegate.topics();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param messageId message identifier
   * @param topics list of topics to unsubscribe
   * @param properties UNSUBSCRIBE message properties
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage create(int messageId, List<String> topics, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage ret = io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttUnsubscribeMessage)io.vertx.mqtt.messages.MqttUnsubscribeMessage.create(messageId, topics, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private List<String> cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttUnsubscribeMessage newInstance(io.vertx.mqtt.messages.MqttUnsubscribeMessage arg) {
    return arg != null ? new MqttUnsubscribeMessage(arg) : null;
  }

}
