/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.mqtt;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mutiny.mqtt.MqttEndpoint;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.mqtt.MqttServer.class)
public class MqttServer {
    public static final TypeArg<MqttServer> __TYPE_ARG = new TypeArg(obj -> new MqttServer((io.vertx.mqtt.MqttServer)obj), MqttServer::getDelegate);
    private final io.vertx.mqtt.MqttServer delegate;

    public MqttServer(io.vertx.mqtt.MqttServer delegate) {
        this.delegate = delegate;
    }

    public MqttServer(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttServer)delegate;
    }

    MqttServer() {
        this.delegate = null;
    }

    public io.vertx.mqtt.MqttServer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttServer that = (MqttServer)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static MqttServer create(io.vertx.mutiny.core.Vertx vertx, MqttServerOptions options) {
        MqttServer ret = MqttServer.newInstance(io.vertx.mqtt.MqttServer.create((Vertx)vertx.getDelegate(), (MqttServerOptions)options));
        return ret;
    }

    public static MqttServer create(io.vertx.mutiny.core.Vertx vertx) {
        MqttServer ret = MqttServer.newInstance(io.vertx.mqtt.MqttServer.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    @CheckReturnValue
    public Uni<MqttServer> listen(int port, String host) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(port, host, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> MqttServer.newInstance(event)))));
    }

    public MqttServer listenAndAwait(int port, String host) {
        return (MqttServer)this.listen(port, host).await().indefinitely();
    }

    @Fluent
    public MqttServer listenAndForget(int port, String host) {
        this.listen(port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MqttServer> listen(int port) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(port, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> MqttServer.newInstance(event)))));
    }

    public MqttServer listenAndAwait(int port) {
        return (MqttServer)this.listen(port).await().indefinitely();
    }

    @Fluent
    public MqttServer listenAndForget(int port) {
        this.listen(port).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MqttServer> listen() {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen((Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> MqttServer.newInstance(event)))));
    }

    public MqttServer listenAndAwait() {
        return (MqttServer)this.listen().await().indefinitely();
    }

    @Fluent
    public MqttServer listenAndForget() {
        this.listen().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private MqttServer __endpointHandler(Handler<MqttEndpoint> handler) {
        this.delegate.endpointHandler((Handler)new DelegatingHandler(handler, event -> MqttEndpoint.newInstance(event)));
        return this;
    }

    public MqttServer endpointHandler(Consumer<MqttEndpoint> handler) {
        return this.__endpointHandler((Handler<MqttEndpoint>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttServer __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttServer exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.close(completionHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static MqttServer newInstance(io.vertx.mqtt.MqttServer arg) {
        return arg != null ? new MqttServer(arg) : null;
    }
}

