/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.net.SocketAddress;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubCompReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRecReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRelReasonCode;
import io.vertx.mqtt.messages.codes.MqttSubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.mqtt.messages.MqttDisconnectMessage;
import io.vertx.mutiny.mqtt.messages.MqttPubAckMessage;
import io.vertx.mutiny.mqtt.messages.MqttPubCompMessage;
import io.vertx.mutiny.mqtt.messages.MqttPubRecMessage;
import io.vertx.mutiny.mqtt.messages.MqttPubRelMessage;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage;
import io.vertx.mutiny.mqtt.messages.MqttUnsubscribeMessage;
import java.util.List;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.mqtt.MqttEndpoint.class)
public class MqttEndpoint {
    public static final TypeArg<MqttEndpoint> __TYPE_ARG = new TypeArg(obj -> new MqttEndpoint((io.vertx.mqtt.MqttEndpoint)obj), MqttEndpoint::getDelegate);
    private final io.vertx.mqtt.MqttEndpoint delegate;
    private io.vertx.mutiny.core.net.SocketAddress cached_0;
    private io.vertx.mutiny.core.net.SocketAddress cached_1;
    private String cached_2;
    private MqttAuth cached_3;
    private MqttWill cached_4;
    private Integer cached_5;
    private String cached_6;
    private Boolean cached_7;
    private Integer cached_8;
    private Integer cached_9;

    public MqttEndpoint(io.vertx.mqtt.MqttEndpoint delegate) {
        this.delegate = delegate;
    }

    public MqttEndpoint(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttEndpoint)delegate;
    }

    MqttEndpoint() {
        this.delegate = null;
    }

    public io.vertx.mqtt.MqttEndpoint getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttEndpoint that = (MqttEndpoint)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void close() {
        this.delegate.close();
    }

    public io.vertx.mutiny.core.net.SocketAddress remoteAddress() {
        io.vertx.mutiny.core.net.SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((SocketAddress)this.delegate.remoteAddress());
        return ret;
    }

    public io.vertx.mutiny.core.net.SocketAddress localAddress() {
        io.vertx.mutiny.core.net.SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((SocketAddress)this.delegate.localAddress());
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public MultiMap httpHeaders() {
        MultiMap ret = MultiMap.newInstance((io.vertx.core.MultiMap)this.delegate.httpHeaders());
        return ret;
    }

    public String httpRequestURI() {
        String ret = this.delegate.httpRequestURI();
        return ret;
    }

    public String clientIdentifier() {
        String ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.clientIdentifier();
        return ret;
    }

    public MqttAuth auth() {
        MqttAuth ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = this.delegate.auth();
        return ret;
    }

    public MqttWill will() {
        MqttWill ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = this.delegate.will();
        return ret;
    }

    public int protocolVersion() {
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        int ret = this.delegate.protocolVersion();
        this.cached_5 = ret;
        return ret;
    }

    public String protocolName() {
        String ret;
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        this.cached_6 = ret = this.delegate.protocolName();
        return ret;
    }

    public boolean isCleanSession() {
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        boolean ret = this.delegate.isCleanSession();
        this.cached_7 = ret;
        return ret;
    }

    public int keepAliveTimeSeconds() {
        if (this.cached_8 != null) {
            return this.cached_8;
        }
        int ret = this.delegate.keepAliveTimeSeconds();
        this.cached_8 = ret;
        return ret;
    }

    public int lastMessageId() {
        if (this.cached_9 != null) {
            return this.cached_9;
        }
        int ret = this.delegate.lastMessageId();
        this.cached_9 = ret;
        return ret;
    }

    public void subscriptionAutoAck(boolean isSubscriptionAutoAck) {
        this.delegate.subscriptionAutoAck(isSubscriptionAutoAck);
    }

    public boolean isSubscriptionAutoAck() {
        boolean ret = this.delegate.isSubscriptionAutoAck();
        return ret;
    }

    @Fluent
    public MqttEndpoint publishAutoAck(boolean isPublishAutoAck) {
        this.delegate.publishAutoAck(isPublishAutoAck);
        return this;
    }

    public boolean isPublishAutoAck() {
        boolean ret = this.delegate.isPublishAutoAck();
        return ret;
    }

    @Fluent
    public MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) {
        this.delegate.autoKeepAlive(isAutoKeepAlive);
        return this;
    }

    public boolean isAutoKeepAlive() {
        boolean ret = this.delegate.isAutoKeepAlive();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    @Fluent
    public MqttEndpoint setClientIdentifier(String clientIdentifier) {
        this.delegate.setClientIdentifier(clientIdentifier);
        return this;
    }

    @Fluent
    private MqttEndpoint __disconnectHandler(Handler<Void> handler) {
        this.delegate.disconnectHandler(handler);
        return this;
    }

    public MqttEndpoint disconnectHandler(Runnable handler) {
        return this.__disconnectHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private MqttEndpoint __disconnectMessageHandler(Handler<MqttDisconnectMessage> handler) {
        this.delegate.disconnectMessageHandler((Handler)new DelegatingHandler(handler, event -> MqttDisconnectMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint disconnectMessageHandler(Consumer<MqttDisconnectMessage> handler) {
        return this.__disconnectMessageHandler((Handler<MqttDisconnectMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __subscribeHandler(Handler<MqttSubscribeMessage> handler) {
        this.delegate.subscribeHandler((Handler)new DelegatingHandler(handler, event -> MqttSubscribeMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint subscribeHandler(Consumer<MqttSubscribeMessage> handler) {
        return this.__subscribeHandler((Handler<MqttSubscribeMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __unsubscribeHandler(Handler<MqttUnsubscribeMessage> handler) {
        this.delegate.unsubscribeHandler((Handler)new DelegatingHandler(handler, event -> MqttUnsubscribeMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint unsubscribeHandler(Consumer<MqttUnsubscribeMessage> handler) {
        return this.__unsubscribeHandler((Handler<MqttUnsubscribeMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishHandler(Handler<MqttPublishMessage> handler) {
        this.delegate.publishHandler((Handler)new DelegatingHandler(handler, event -> MqttPublishMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishHandler(Consumer<MqttPublishMessage> handler) {
        return this.__publishHandler((Handler<MqttPublishMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishAcknowledgeHandler(Handler<Integer> handler) {
        this.delegate.publishAcknowledgeHandler(handler);
        return this;
    }

    public MqttEndpoint publishAcknowledgeHandler(Consumer<Integer> handler) {
        return this.__publishAcknowledgeHandler((Handler<Integer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishAcknowledgeMessageHandler(Handler<MqttPubAckMessage> handler) {
        this.delegate.publishAcknowledgeMessageHandler((Handler)new DelegatingHandler(handler, event -> MqttPubAckMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishAcknowledgeMessageHandler(Consumer<MqttPubAckMessage> handler) {
        return this.__publishAcknowledgeMessageHandler((Handler<MqttPubAckMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishReceivedHandler(Handler<Integer> handler) {
        this.delegate.publishReceivedHandler(handler);
        return this;
    }

    public MqttEndpoint publishReceivedHandler(Consumer<Integer> handler) {
        return this.__publishReceivedHandler((Handler<Integer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishReceivedMessageHandler(Handler<MqttPubRecMessage> handler) {
        this.delegate.publishReceivedMessageHandler((Handler)new DelegatingHandler(handler, event -> MqttPubRecMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishReceivedMessageHandler(Consumer<MqttPubRecMessage> handler) {
        return this.__publishReceivedMessageHandler((Handler<MqttPubRecMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishReleaseHandler(Handler<Integer> handler) {
        this.delegate.publishReleaseHandler(handler);
        return this;
    }

    public MqttEndpoint publishReleaseHandler(Consumer<Integer> handler) {
        return this.__publishReleaseHandler((Handler<Integer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishReleaseMessageHandler(Handler<MqttPubRelMessage> handler) {
        this.delegate.publishReleaseMessageHandler((Handler)new DelegatingHandler(handler, event -> MqttPubRelMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishReleaseMessageHandler(Consumer<MqttPubRelMessage> handler) {
        return this.__publishReleaseMessageHandler((Handler<MqttPubRelMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishCompletionHandler(Handler<Integer> handler) {
        this.delegate.publishCompletionHandler(handler);
        return this;
    }

    public MqttEndpoint publishCompletionHandler(Consumer<Integer> handler) {
        return this.__publishCompletionHandler((Handler<Integer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __publishCompletionMessageHandler(Handler<MqttPubCompMessage> handler) {
        this.delegate.publishCompletionMessageHandler((Handler)new DelegatingHandler(handler, event -> MqttPubCompMessage.newInstance(event)));
        return this;
    }

    public MqttEndpoint publishCompletionMessageHandler(Consumer<MqttPubCompMessage> handler) {
        return this.__publishCompletionMessageHandler((Handler<MqttPubCompMessage>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttEndpoint __pingHandler(Handler<Void> handler) {
        this.delegate.pingHandler(handler);
        return this;
    }

    public MqttEndpoint pingHandler(Runnable handler) {
        return this.__pingHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private MqttEndpoint __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public MqttEndpoint closeHandler(Runnable handler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private MqttEndpoint __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttEndpoint exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    public MqttEndpoint accept() {
        this.delegate.accept();
        return this;
    }

    @Fluent
    public MqttEndpoint accept(boolean sessionPresent) {
        this.delegate.accept(sessionPresent);
        return this;
    }

    @Fluent
    public MqttEndpoint reject(MqttConnectReturnCode returnCode) {
        this.delegate.reject(returnCode);
        return this;
    }

    @Fluent
    public MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<MqttQoS> grantedQoSLevels) {
        this.delegate.subscribeAcknowledge(subscribeMessageId, grantedQoSLevels);
        return this;
    }

    @Fluent
    public MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId) {
        this.delegate.unsubscribeAcknowledge(unsubscribeMessageId);
        return this;
    }

    @Fluent
    public MqttEndpoint publishAcknowledge(int publishMessageId) {
        this.delegate.publishAcknowledge(publishMessageId);
        return this;
    }

    @Fluent
    public MqttEndpoint publishReceived(int publishMessageId) {
        this.delegate.publishReceived(publishMessageId);
        return this;
    }

    @Fluent
    public MqttEndpoint publishRelease(int publishMessageId) {
        this.delegate.publishRelease(publishMessageId);
        return this;
    }

    @Fluent
    public MqttEndpoint publishComplete(int publishMessageId) {
        this.delegate.publishComplete(publishMessageId);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultUni.toUni(publishSentHandler -> this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler));
    }

    public Integer publishAndAwait(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return (Integer)this.publish(topic, payload, qosLevel, isDup, isRetain).await().indefinitely();
    }

    @Fluent
    public MqttEndpoint publishAndForget(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        this.publish(topic, payload, qosLevel, isDup, isRetain).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) {
        return AsyncResultUni.toUni(publishSentHandler -> this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, publishSentHandler));
    }

    public Integer publishAndAwait(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) {
        return (Integer)this.publish(topic, payload, qosLevel, isDup, isRetain, messageId).await().indefinitely();
    }

    @Fluent
    public MqttEndpoint publishAndForget(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) {
        this.publish(topic, payload, qosLevel, isDup, isRetain, messageId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public MqttEndpoint pong() {
        this.delegate.pong();
        return this;
    }

    public MqttProperties connectProperties() {
        MqttProperties ret = this.delegate.connectProperties();
        return ret;
    }

    @Fluent
    public MqttEndpoint accept(boolean sessionPresent, MqttProperties properties) {
        this.delegate.accept(sessionPresent, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint reject(MqttConnectReturnCode returnCode, MqttProperties properties) {
        this.delegate.reject(returnCode, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<MqttSubAckReasonCode> reasonCodes, MqttProperties properties) {
        this.delegate.subscribeAcknowledge(subscribeMessageId, reasonCodes, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId, List<MqttUnsubAckReasonCode> reasonCodes, MqttProperties properties) {
        this.delegate.unsubscribeAcknowledge(unsubscribeMessageId, reasonCodes, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint publishAcknowledge(int publishMessageId, MqttPubAckReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishAcknowledge(publishMessageId, reasonCode, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint publishReceived(int publishMessageId, MqttPubRecReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishReceived(publishMessageId, reasonCode, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint publishRelease(int publishMessageId, MqttPubRelReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishRelease(publishMessageId, reasonCode, properties);
        return this;
    }

    @Fluent
    public MqttEndpoint publishComplete(int publishMessageId, MqttPubCompReasonCode reasonCode, MqttProperties properties) {
        this.delegate.publishComplete(publishMessageId, reasonCode, properties);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, MqttProperties properties) {
        return AsyncResultUni.toUni(publishSentHandler -> this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, properties, publishSentHandler));
    }

    public Integer publishAndAwait(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, MqttProperties properties) {
        return (Integer)this.publish(topic, payload, qosLevel, isDup, isRetain, messageId, properties).await().indefinitely();
    }

    @Fluent
    public MqttEndpoint publishAndForget(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, MqttProperties properties) {
        this.publish(topic, payload, qosLevel, isDup, isRetain, messageId, properties).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public MqttEndpoint disconnect(MqttDisconnectReasonCode code, MqttProperties properties) {
        this.delegate.disconnect(code, properties);
        return this;
    }

    public static MqttEndpoint newInstance(io.vertx.mqtt.MqttEndpoint arg) {
        return arg != null ? new MqttEndpoint(arg) : null;
    }
}

