package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mqtt.messages.codes.MqttPubRecReasonCode;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT PUBREC message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPubRecMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttPubRecMessage.class)
public class MqttPubRecMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttPubRecMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttPubRecMessage((io.vertx.mqtt.messages.MqttPubRecMessage) obj),
    MqttPubRecMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPubRecMessage delegate;
  
  public MqttPubRecMessage(io.vertx.mqtt.messages.MqttPubRecMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPubRecMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPubRecMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttPubRecMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttPubRecMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPubRecMessage that = (MqttPubRecMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return reason code from the pubrec request
   */
  public io.vertx.mqtt.messages.codes.MqttPubRecReasonCode code() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mqtt.messages.codes.MqttPubRecReasonCode ret = delegate.code();
    cached_1 = ret;
    return ret;
  }

  /**
   * @param messageId message Id
   * @param code return code from the pubrec
   * @param properties MQTT properties of the pubrec message
   * @return 
   */
  public static io.vertx.mutiny.mqtt.messages.MqttPubRecMessage create(int messageId, io.vertx.mqtt.messages.codes.MqttPubRecReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttPubRecMessage ret = io.vertx.mutiny.mqtt.messages.MqttPubRecMessage.newInstance((io.vertx.mqtt.messages.MqttPubRecMessage)io.vertx.mqtt.messages.MqttPubRecMessage.create(messageId, code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.vertx.mqtt.messages.codes.MqttPubRecReasonCode cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttPubRecMessage newInstance(io.vertx.mqtt.messages.MqttPubRecMessage arg) {
    return arg != null ? new MqttPubRecMessage(arg) : null;
  }

}
