package io.vertx.mutiny.mqtt.messages;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttProperties;

/**
 * Represents an MQTT SUBSCRIBE message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttSubscribeMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.messages.MqttSubscribeMessage.class)
public class MqttSubscribeMessage implements io.vertx.mutiny.mqtt.messages.MqttMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttSubscribeMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttSubscribeMessage((io.vertx.mqtt.messages.MqttSubscribeMessage) obj),
    MqttSubscribeMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttSubscribeMessage delegate;
  
  public MqttSubscribeMessage(io.vertx.mqtt.messages.MqttSubscribeMessage delegate) {
    this.delegate = delegate;
  }

  public MqttSubscribeMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttSubscribeMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttSubscribeMessage() {
    this.delegate = null;
  }

  public io.vertx.mqtt.messages.MqttSubscribeMessage getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.mqtt.MqttTopicSubscription> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.mqtt.MqttTopicSubscription>(o1 -> io.vertx.mutiny.mqtt.MqttTopicSubscription.newInstance((io.vertx.mqtt.MqttTopicSubscription)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttSubscribeMessage that = (MqttSubscribeMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return List with topics and related quolity of service levels
   */
  public List<io.vertx.mutiny.mqtt.MqttTopicSubscription> topicSubscriptions() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<io.vertx.mutiny.mqtt.MqttTopicSubscription> ret = delegate.topicSubscriptions().stream().map(elt -> io.vertx.mutiny.mqtt.MqttTopicSubscription.newInstance((io.vertx.mqtt.MqttTopicSubscription)elt)).collect(java.util.stream.Collectors.toList());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param messageId message identifier
   * @param topicSubscriptions list with topics and related quality of service levels (from Netty)
   * @param properties MQTT message properties
   * @return Vert.x subscribe message
   */
  public static io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage create(int messageId, List<io.netty.handler.codec.mqtt.MqttTopicSubscription> topicSubscriptions, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage ret = io.vertx.mutiny.mqtt.messages.MqttSubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttSubscribeMessage)io.vertx.mqtt.messages.MqttSubscribeMessage.create(messageId, topicSubscriptions, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private List<io.vertx.mutiny.mqtt.MqttTopicSubscription> cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static  MqttSubscribeMessage newInstance(io.vertx.mqtt.messages.MqttSubscribeMessage arg) {
    return arg != null ? new MqttSubscribeMessage(arg) : null;
  }

}
