package io.vertx.mutiny.mqtt;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;

/**
 * Represents a subscription to a topic
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttTopicSubscription original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mqtt.MqttTopicSubscription.class)
public class MqttTopicSubscription {

  public static final io.smallrye.mutiny.vertx.TypeArg<MqttTopicSubscription> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MqttTopicSubscription((io.vertx.mqtt.MqttTopicSubscription) obj),
    MqttTopicSubscription::getDelegate
  );

  private final io.vertx.mqtt.MqttTopicSubscription delegate;
  
  public MqttTopicSubscription(io.vertx.mqtt.MqttTopicSubscription delegate) {
    this.delegate = delegate;
  }

  public MqttTopicSubscription(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttTopicSubscription)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MqttTopicSubscription() {
    this.delegate = null;
  }

  public io.vertx.mqtt.MqttTopicSubscription getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttTopicSubscription that = (MqttTopicSubscription) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return Subscription topic name
   */
  public String topicName() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.topicName();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return Quality of Service level for the subscription
   */
  public io.netty.handler.codec.mqtt.MqttQoS qualityOfService() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.netty.handler.codec.mqtt.MqttQoS ret = delegate.qualityOfService();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return Subscription options
   */
  public io.netty.handler.codec.mqtt.MqttSubscriptionOption subscriptionOption() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttSubscriptionOption ret = delegate.subscriptionOption();
    cached_2 = ret;
    return ret;
  }

  private String cached_0;
  private io.netty.handler.codec.mqtt.MqttQoS cached_1;
  private io.netty.handler.codec.mqtt.MqttSubscriptionOption cached_2;
  public static  MqttTopicSubscription newInstance(io.vertx.mqtt.MqttTopicSubscription arg) {
    return arg != null ? new MqttTopicSubscription(arg) : null;
  }

}
