package io.vertx.mutiny.mssqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.mssqlclient.MSSQLInfo;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A connection to Microsoft SQL Server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mssqlclient.MSSQLConnection.class)
public class MSSQLConnection extends io.vertx.mutiny.sqlclient.SqlConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<MSSQLConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MSSQLConnection((io.vertx.mssqlclient.MSSQLConnection) obj),
    MSSQLConnection::getDelegate
  );

  private final io.vertx.mssqlclient.MSSQLConnection delegate;
  
  public MSSQLConnection(io.vertx.mssqlclient.MSSQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MSSQLConnection(Object delegate) {
    super((io.vertx.mssqlclient.MSSQLConnection)delegate);
    this.delegate = (io.vertx.mssqlclient.MSSQLConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MSSQLConnection() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.mssqlclient.MSSQLConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MSSQLConnection that = (MSSQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Create a connection to SQL Server with the given <code>connectOptions</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.mssqlclient.MSSQLConnection> connect(io.vertx.mutiny.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.mssqlclient.MSSQLConnection.connect(vertx.getDelegate(), connectOptions, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,MSSQLConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return the MSSQLConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) { 
    return (io.vertx.mutiny.mssqlclient.MSSQLConnection) connect(vertx, connectOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,MSSQLConnectOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,MSSQLConnectOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,MSSQLConnectOptions)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) { 
    connect(vertx, connectOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect} with options built from <code>connectionUri</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx 
   * @param connectionUri 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.mssqlclient.MSSQLConnection> connect(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.mssqlclient.MSSQLConnection.connect(vertx.getDelegate(), connectionUri, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx 
   * @param connectionUri 
   * @return the MSSQLConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return (io.vertx.mutiny.mssqlclient.MSSQLConnection) connect(vertx, connectionUri).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#connect(io.vertx.mutiny.core.Vertx,String)} but you don't need to compose it with other operations.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    connect(vertx, connectionUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * 
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param s 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.PreparedStatement> prepare(String s) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.prepare(s, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#prepare(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param s 
   * @return the PreparedStatement instance produced by the operation.
   */
  public io.vertx.mutiny.sqlclient.PreparedStatement prepareAndAwait(String s) { 
    return (io.vertx.mutiny.sqlclient.PreparedStatement) prepare(s).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#prepare(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#prepare(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mssqlclient.MSSQLConnection#prepare(String)} but you don't need to compose it with other operations.
   * @param s 
   * @return the instance of MSSQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mssqlclient.MSSQLConnection prepareAndForget(String s) { 
    prepare(s).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler 
   * @return the instance of MSSQLConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.mssqlclient.MSSQLConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.mssqlclient.MSSQLConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler 
   * @return the instance of MSSQLConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.mssqlclient.MSSQLConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.mssqlclient.MSSQLConnection closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.mssqlclient.MSSQLConnection __infoHandler(Handler<io.vertx.mssqlclient.MSSQLInfo> handler) { 
    delegate.infoHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.mssqlclient.MSSQLConnection infoHandler(java.util.function.Consumer<io.vertx.mssqlclient.MSSQLInfo> handler) {
    return __infoHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.mutiny.mssqlclient.MSSQLConnection instance}
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLConnection cast(io.vertx.mutiny.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.mutiny.mssqlclient.MSSQLConnection ret = io.vertx.mutiny.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)io.vertx.mssqlclient.MSSQLConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static  MSSQLConnection newInstance(io.vertx.mssqlclient.MSSQLConnection arg) {
    return arg != null ? new MSSQLConnection(arg) : null;
  }

}
