package io.vertx.mutiny.oracleclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Entry point for building Oracle clients.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OracleBuilder original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.oracleclient.OracleBuilder.class)
public class OracleBuilder implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<OracleBuilder> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OracleBuilder((io.vertx.oracleclient.OracleBuilder) obj),
    OracleBuilder::getDelegate
  );

  private final io.vertx.oracleclient.OracleBuilder delegate;
  
  public OracleBuilder(io.vertx.oracleclient.OracleBuilder delegate) {
    this.delegate = delegate;
  }

  public OracleBuilder(Object delegate) {
    this.delegate = (io.vertx.oracleclient.OracleBuilder)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OracleBuilder() {
    this.delegate = null;
  }

  @Override
  public io.vertx.oracleclient.OracleBuilder getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.Pool> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.sqlclient.Pool>(o1 -> io.vertx.mutiny.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OracleBuilder that = (OracleBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param block 
   * @return the pool as configured by the code <code>block</code>
   */
  private static io.vertx.mutiny.sqlclient.Pool __pool(Handler<io.vertx.mutiny.sqlclient.ClientBuilder<io.vertx.mutiny.sqlclient.Pool>> block) { 
    io.vertx.mutiny.sqlclient.Pool ret = io.vertx.mutiny.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.oracleclient.OracleBuilder.pool(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(block, event -> io.vertx.mutiny.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)event, new TypeArg<io.vertx.mutiny.sqlclient.Pool>(o0 -> io.vertx.mutiny.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o0), o0 -> o0.getDelegate())))));
    return ret;
  }

  /**
   * @param block 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.Pool pool(java.util.function.Consumer<io.vertx.mutiny.sqlclient.ClientBuilder<io.vertx.mutiny.sqlclient.Pool>> block) {
    return __pool(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(block));
  }

  /**
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.ClientBuilder<io.vertx.mutiny.sqlclient.Pool> pool() { 
    io.vertx.mutiny.sqlclient.ClientBuilder<io.vertx.mutiny.sqlclient.Pool> ret = io.vertx.mutiny.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)io.vertx.oracleclient.OracleBuilder.pool(), TYPE_ARG_0);
    return ret;
  }

  public static  OracleBuilder newInstance(io.vertx.oracleclient.OracleBuilder arg) {
    return arg != null ? new OracleBuilder(arg) : null;
  }

}
